# TypeHandlerLibrary

>It is really not subsystem. but used by them

A library of type handlers. This is used for the construction of class metadata. This library should be initialised
by adding a number of base type handlers, describing how to serialize each supported type. It will then produce
serializers for classes (through their ClassMetadata) on request.

Type handlers provide the algorithms for serializing and deserializing types - this uses an implementation agnostic set of interfaces
so TypeHandlers can be used for different serialization techniques (Json, Protobuf, etc).

#### Structure

[![](https://mermaid.ink/img/eyJjb2RlIjoiZ3JhcGggTFJcbiAgICBzdWJncmFwaCBmb3JtYXRcbiAgICAgIFBlcnNpc3RlZERhdGFcbiAgICAgIFBlcnNpc3RlZERhdGFTZXJpYWxpemVyXG4gICAgICBQZXJzaXN0ZWREYXRhUmVhZGVyXG4gICAgICBQZXJzaXN0ZWREYXRhV3JpdGVyXG4gICAgZW5kIFxuXG4gICAgVHlwZUhhbmRsZXJMaWJyYXJ5XG4gICAgU2VyaWFsaXplclxuXG4gICAgVHlwZUhhbmRsZXJGYWN0b3J5XG4gICAgVHlwZUhhbmRsZXJcblxuICAgIFxuICAgIFR5cGVIYW5kbGVyTGlicmFyeSAtLS0-IHxwcm92aWRlc3wgVHlwZUhhbmRsZXJGYWN0b3J5XG4gICAgVHlwZUhhbmRsZXJGYWN0b3J5IC0tLT4gfHByb3ZpZGVzfCBUeXBlSGFuZGxlclxuICAgIFR5cGVIYW5kbGVyICYgVHlwZUhhbmRsZXJGYWN0b3J5IC0tLT4gfHJlZ2lzdGVyfCBUeXBlSGFuZGxlckxpYnJhcnlcbiAgICBcbiAgICBUeXBlSGFuZGxlciAtLS0-IHx1c2VzIGZvciBzZXJpYWxpemF0aW9ufCBQZXJzaXN0ZWREYXRhU2VyaWFsaXplclxuICAgIFR5cGVIYW5kbGVyIC0tLT4gfHJlc3VsdCBvZiBzZXJpYWxpemF0aW9uIHwgUGVyc2lzdGVkRGF0YVxuICAgIFR5cGVIYW5kbGVyIC0tLT4gfHNvdXJjZSBvZiBkZXNlcmlhbGl6YXRpb24gfCBQZXJzaXN0ZWREYXRhXG4gICAgU2VyaWFsaXplciAtLS0-IHx1c2luZyBmb3IgcmVjZWl2aW5nIFR5cGVIYW5kbGVyIHwgVHlwZUhhbmRsZXJMaWJyYXJ5XG4gICAgU2VyaWFsaXplciAtLS0-IHwgZGF0YSBmb3Igd3JpdGluZy9yZWFkaW5nIHwgUGVyc2lzdGVkRGF0YSBcbiAgICBTZXJpYWxpemVyIC0tLT4gfCB1c2UgZm9yIHNlcmlhbGl6YXRpb24gdmlhIFR5cGVIYW5kbGVyfCBQZXJzaXN0ZWREYXRhU2VyaWFsaXplclxuICAgIFNlcmlhbGl6ZXIgLS0tPiB8d3JpdGUgUGVyc2lzdGVkRGF0YSB0byB8IFBlcnNpc3RlZERhdGFXcml0ZXJcbiAgICBTZXJpYWxpemVyIC0tLT4gfHJlYWQgUGVyc2lzdGVkRGF0YSBmcm9tIHwgUGVyc2lzdGVkRGF0YVJlYWRlclxuICAgIFBlcnNpc3RlZERhdGFTZXJpYWxpemVyIC0tLT4gfGNyZWF0ZXN8IFBlcnNpc3RlZERhdGEiLCJtZXJtYWlkIjp7InRoZW1lIjoiZGVmYXVsdCIsInRoZW1lVmFyaWFibGVzIjp7ImJhY2tncm91bmQiOiJ3aGl0ZSIsInByaW1hcnlDb2xvciI6IiNFQ0VDRkYiLCJzZWNvbmRhcnlDb2xvciI6IiNmZmZmZGUiLCJ0ZXJ0aWFyeUNvbG9yIjoiaHNsKDgwLCAxMDAlLCA5Ni4yNzQ1MDk4MDM5JSkiLCJwcmltYXJ5Qm9yZGVyQ29sb3IiOiJoc2woMjQwLCA2MCUsIDg2LjI3NDUwOTgwMzklKSIsInNlY29uZGFyeUJvcmRlckNvbG9yIjoiaHNsKDYwLCA2MCUsIDgzLjUyOTQxMTc2NDclKSIsInRlcnRpYXJ5Qm9yZGVyQ29sb3IiOiJoc2woODAsIDYwJSwgODYuMjc0NTA5ODAzOSUpIiwicHJpbWFyeVRleHRDb2xvciI6IiMxMzEzMDAiLCJzZWNvbmRhcnlUZXh0Q29sb3IiOiIjMDAwMDIxIiwidGVydGlhcnlUZXh0Q29sb3IiOiJyZ2IoOS41MDAwMDAwMDAxLCA5LjUwMDAwMDAwMDEsIDkuNTAwMDAwMDAwMSkiLCJsaW5lQ29sb3IiOiIjMzMzMzMzIiwidGV4dENvbG9yIjoiIzMzMyIsIm1haW5Ca2ciOiIjRUNFQ0ZGIiwic2Vjb25kQmtnIjoiI2ZmZmZkZSIsImJvcmRlcjEiOiIjOTM3MERCIiwiYm9yZGVyMiI6IiNhYWFhMzMiLCJhcnJvd2hlYWRDb2xvciI6IiMzMzMzMzMiLCJmb250RmFtaWx5IjoiXCJ0cmVidWNoZXQgbXNcIiwgdmVyZGFuYSwgYXJpYWwiLCJmb250U2l6ZSI6IjE2cHgiLCJsYWJlbEJhY2tncm91bmQiOiIjZThlOGU4Iiwibm9kZUJrZyI6IiNFQ0VDRkYiLCJub2RlQm9yZGVyIjoiIzkzNzBEQiIsImNsdXN0ZXJCa2ciOiIjZmZmZmRlIiwiY2x1c3RlckJvcmRlciI6IiNhYWFhMzMiLCJkZWZhdWx0TGlua0NvbG9yIjoiIzMzMzMzMyIsInRpdGxlQ29sb3IiOiIjMzMzIiwiZWRnZUxhYmVsQmFja2dyb3VuZCI6IiNlOGU4ZTgiLCJhY3RvckJvcmRlciI6ImhzbCgyNTkuNjI2MTY4MjI0MywgNTkuNzc2NTM2MzEyOCUsIDg3LjkwMTk2MDc4NDMlKSIsImFjdG9yQmtnIjoiI0VDRUNGRiIsImFjdG9yVGV4dENvbG9yIjoiYmxhY2siLCJhY3RvckxpbmVDb2xvciI6ImdyZXkiLCJzaWduYWxDb2xvciI6IiMzMzMiLCJzaWduYWxUZXh0Q29sb3IiOiIjMzMzIiwibGFiZWxCb3hCa2dDb2xvciI6IiNFQ0VDRkYiLCJsYWJlbEJveEJvcmRlckNvbG9yIjoiaHNsKDI1OS42MjYxNjgyMjQzLCA1OS43NzY1MzYzMTI4JSwgODcuOTAxOTYwNzg0MyUpIiwibGFiZWxUZXh0Q29sb3IiOiJibGFjayIsImxvb3BUZXh0Q29sb3IiOiJibGFjayIsIm5vdGVCb3JkZXJDb2xvciI6IiNhYWFhMzMiLCJub3RlQmtnQ29sb3IiOiIjZmZmNWFkIiwibm90ZVRleHRDb2xvciI6ImJsYWNrIiwiYWN0aXZhdGlvbkJvcmRlckNvbG9yIjoiIzY2NiIsImFjdGl2YXRpb25Ca2dDb2xvciI6IiNmNGY0ZjQiLCJzZXF1ZW5jZU51bWJlckNvbG9yIjoid2hpdGUiLCJzZWN0aW9uQmtnQ29sb3IiOiJyZ2JhKDEwMiwgMTAyLCAyNTUsIDAuNDkpIiwiYWx0U2VjdGlvbkJrZ0NvbG9yIjoid2hpdGUiLCJzZWN0aW9uQmtnQ29sb3IyIjoiI2ZmZjQwMCIsInRhc2tCb3JkZXJDb2xvciI6IiM1MzRmYmMiLCJ0YXNrQmtnQ29sb3IiOiIjOGE5MGRkIiwidGFza1RleHRMaWdodENvbG9yIjoid2hpdGUiLCJ0YXNrVGV4dENvbG9yIjoid2hpdGUiLCJ0YXNrVGV4dERhcmtDb2xvciI6ImJsYWNrIiwidGFza1RleHRPdXRzaWRlQ29sb3IiOiJibGFjayIsInRhc2tUZXh0Q2xpY2thYmxlQ29sb3IiOiIjMDAzMTYzIiwiYWN0aXZlVGFza0JvcmRlckNvbG9yIjoiIzUzNGZiYyIsImFjdGl2ZVRhc2tCa2dDb2xvciI6IiNiZmM3ZmYiLCJncmlkQ29sb3IiOiJsaWdodGdyZXkiLCJkb25lVGFza0JrZ0NvbG9yIjoibGlnaHRncmV5IiwiZG9uZVRhc2tCb3JkZXJDb2xvciI6ImdyZXkiLCJjcml0Qm9yZGVyQ29sb3IiOiIjZmY4ODg4IiwiY3JpdEJrZ0NvbG9yIjoicmVkIiwidG9kYXlMaW5lQ29sb3IiOiJyZWQiLCJsYWJlbENvbG9yIjoiYmxhY2siLCJlcnJvckJrZ0NvbG9yIjoiIzU1MjIyMiIsImVycm9yVGV4dENvbG9yIjoiIzU1MjIyMiIsImNsYXNzVGV4dCI6IiMxMzEzMDAiLCJmaWxsVHlwZTAiOiIjRUNFQ0ZGIiwiZmlsbFR5cGUxIjoiI2ZmZmZkZSIsImZpbGxUeXBlMiI6ImhzbCgzMDQsIDEwMCUsIDk2LjI3NDUwOTgwMzklKSIsImZpbGxUeXBlMyI6ImhzbCgxMjQsIDEwMCUsIDkzLjUyOTQxMTc2NDclKSIsImZpbGxUeXBlNCI6ImhzbCgxNzYsIDEwMCUsIDk2LjI3NDUwOTgwMzklKSIsImZpbGxUeXBlNSI6ImhzbCgtNCwgMTAwJSwgOTMuNTI5NDExNzY0NyUpIiwiZmlsbFR5cGU2IjoiaHNsKDgsIDEwMCUsIDk2LjI3NDUwOTgwMzklKSIsImZpbGxUeXBlNyI6ImhzbCgxODgsIDEwMCUsIDkzLjUyOTQxMTc2NDclKSJ9fSwidXBkYXRlRWRpdG9yIjpmYWxzZX0)](https://mermaid-js.github.io/mermaid-live-editor/#/edit/eyJjb2RlIjoiZ3JhcGggTFJcbiAgICBzdWJncmFwaCBmb3JtYXRcbiAgICAgIFBlcnNpc3RlZERhdGFcbiAgICAgIFBlcnNpc3RlZERhdGFTZXJpYWxpemVyXG4gICAgICBQZXJzaXN0ZWREYXRhUmVhZGVyXG4gICAgICBQZXJzaXN0ZWREYXRhV3JpdGVyXG4gICAgZW5kIFxuXG4gICAgVHlwZUhhbmRsZXJMaWJyYXJ5XG4gICAgU2VyaWFsaXplclxuXG4gICAgVHlwZUhhbmRsZXJGYWN0b3J5XG4gICAgVHlwZUhhbmRsZXJcblxuICAgIFxuICAgIFR5cGVIYW5kbGVyTGlicmFyeSAtLS0-IHxwcm92aWRlc3wgVHlwZUhhbmRsZXJGYWN0b3J5XG4gICAgVHlwZUhhbmRsZXJGYWN0b3J5IC0tLT4gfHByb3ZpZGVzfCBUeXBlSGFuZGxlclxuICAgIFR5cGVIYW5kbGVyICYgVHlwZUhhbmRsZXJGYWN0b3J5IC0tLT4gfHJlZ2lzdGVyfCBUeXBlSGFuZGxlckxpYnJhcnlcbiAgICBcbiAgICBUeXBlSGFuZGxlciAtLS0-IHx1c2VzIGZvciBzZXJpYWxpemF0aW9ufCBQZXJzaXN0ZWREYXRhU2VyaWFsaXplclxuICAgIFR5cGVIYW5kbGVyIC0tLT4gfHJlc3VsdCBvZiBzZXJpYWxpemF0aW9uIHwgUGVyc2lzdGVkRGF0YVxuICAgIFR5cGVIYW5kbGVyIC0tLT4gfHNvdXJjZSBvZiBkZXNlcmlhbGl6YXRpb24gfCBQZXJzaXN0ZWREYXRhXG4gICAgU2VyaWFsaXplciAtLS0-IHx1c2luZyBmb3IgcmVjZWl2aW5nIFR5cGVIYW5kbGVyIHwgVHlwZUhhbmRsZXJMaWJyYXJ5XG4gICAgU2VyaWFsaXplciAtLS0-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)
* `Serializer` - central class for (de)serialization.
* `TypeHandlerLibrary` - core class for registering `TypeHandlerFactory`s 
* `TypeHandlerFactory` - factory for `TypeHandler`s
* `TypeHandler` - interface for handling convertiong from `<your class>` to PersistentData and otherwise. 
* `PersistedData` - interface for target format/protocol(e.g. gson/protobuf)
* `PersistedDataSerializer` - interface for creating/filling `PersistedData`
* `PersistedDataWriter` - interface for writing `PersistedData` to bytes or outputStream
* `PersistedDataReader` - interface for reading `PersistedData` from bytes or inputStream

#### Usage
1. Create `Serializer`:
    ```java
    Serializer serializer = new Serializer(
            typeHandlerLibrary, // Previosly filled with your TypeHandlers
            persistedDataSerializer, // format implementation
            persistedDataWriter, // format implementation
            persistedDataReader, // format implementation
    )
    ```
2. Serialize:
    ```java
    serializer.serialize(
                       obj, // Your object to serialize
                       TypeInfo.of(YourClass.class), // Type of obj (also can handle generic types)
                       outputStream); // Output stream for writing. 
    ```
    or 
    ```java
    byte[] bytes = serializer.serialize(
                       obj, // Your object to serialize
                       TypeInfo.of(YourClass.class)); // Type of obj (also can handle generic types)     
    ```
3. Deserialize:
    ```java
    Optional<YourClass> obj = serializer.deserialize(  
                        TypeInfo.of(YourClass.class), // Type of obj (also can handle generic types)
                        inputStream); // Input Stream for reading.
    ```
    or 
    ```java
   byte[] bytes; // your format data in bytes; 
   Optional<YourClass> obj =  serializer.deserialize(
                       TypeInfo.of(YourClass.class), // Type of obj (also can handle generic types)
                       bytes);     
    ```


#### (De)Serialization Process
Serialization:
[![](https://mermaid.ink/img/eyJjb2RlIjoic2VxdWVuY2VEaWFncmFtXG4gICAgICBZT1UgLS0-PiBTZXJpYWxpemVyOiBTZXJpemFsaXplIE15IE9iamVjdCBpbiBgb3V0cHV0YFxuICAgICAgU2VyaWFsaXplciAtLT4-IFR5cGVIYW5kbGVyTGlicmFyeTogR2l2ZSBNZSBgVHlwZUhhbmRsZXJgIGZvciB0aGlzIE9iamVjdFxuICAgICAgVHlwZUhhbmRsZXJMaWJyYXJ5IC0tPj4gVHlwZUhhbmRsZXJMaWJyYXJ5OiBmaW5kaW5nIGBUeXBlSGFuZGxlckZhY3RvcnlgIGluIHN0b3JlXG4gICAgICBUeXBlSGFuZGxlckxpYnJhcnkgLS0-PiBUeXBlSGFuZGxlckZhY3Rvcnk6IEdpdmUgTWUgYFR5cGVIYW5kbGVyYFxuICAgICAgVHlwZUhhbmRsZXJGYWN0b3J5IC0tPj4gVHlwZUhhbmRsZXJMaWJyYXJ5OiByZXR1cm5zIGBUeXBlSGFuZGxlcmBcbiAgICAgIFR5cGVIYW5kbGVyTGlicmFyeSAtLT4-IFNlcmlhbGl6ZXI6ICByZXR1cm5zIGBUeXBlSGFuZGxlcmBcbiAgICAgIFNlcmlhbGl6ZXIgLS0-PiBQZXJzaXN0ZWREYXRhU2VyaWFsaXplcjogc2VyaWFsaXplciBvYmplY3Qgd2l0aCBgVHlwZUhhbmRsZXJgXG4gICAgICBQZXJzaXN0ZWREYXRhU2VyaWFsaXplciAtLT4-IFNlcmlhbGl6ZXI6IHJldHVybnMgYFBlcnNpc3RlZERhdGFgXG4gICAgICBTZXJpYWxpemVyIC0tPj4gUGVyc2lzdGVkRGF0YVdyaXRlcjogd3JpdGUgYFBlcnNpc3RlZERhdGFgIHRvIGBvdXRwdXRgXG4gICAgICBQZXJzaXN0ZWREYXRhV3JpdGVyIC0tPj4gU2VyaWFsaXplcjogb3B0aW9uYWw6IHJldHVybnMgYGJ5dGVbXWAgb3IgYHZvaWRgXG4gICAgICBTZXJpYWxpemVyIC0tPj4gWU9VOiBvcHRpb25hbDogcmV0dXJucyBgYnl0ZVtdYCBvciBgdm9pZGBcbiIsIm1lcm1haWQiOnt9LCJ1cGRhdGVFZGl0b3IiOmZhbHNlfQ)](https://mermaid-js.github.io/mermaid-live-editor/#/edit/eyJjb2RlIjoic2VxdWVuY2VEaWFncmFtXG4gICAgICBZT1UgLS0-PiBTZXJpYWxpemVyOiBTZXJpemFsaXplIE15IE9iamVjdCBpbiBgb3V0cHV0YFxuICAgICAgU2VyaWFsaXplciAtLT4-IFR5cGVIYW5kbGVyTGlicmFyeTogR2l2ZSBNZSBgVHlwZUhhbmRsZXJgIGZvciB0aGlzIE9iamVjdFxuICAgICAgVHlwZUhhbmRsZXJMaWJyYXJ5IC0tPj4gVHlwZUhhbmRsZXJMaWJyYXJ5OiBmaW5kaW5nIGBUeXBlSGFuZGxlckZhY3RvcnlgIGluIHN0b3JlXG4gICAgICBUeXBlSGFuZGxlckxpYnJhcnkgLS0-PiBUeXBlSGFuZGxlckZhY3Rvcnk6IEdpdmUgTWUgYFR5cGVIYW5kbGVyYFxuICAgICAgVHlwZUhhbmRsZXJGYWN0b3J5IC0tPj4gVHlwZUhhbmRsZXJMaWJyYXJ5OiByZXR1cm5zIGBUeXBlSGFuZGxlcmBcbiAgICAgIFR5cGVIYW5kbGVyTGlicmFyeSAtLT4-IFNlcmlhbGl6ZXI6ICByZXR1cm5zIGBUeXBlSGFuZGxlcmBcbiAgICAgIFNlcmlhbGl6ZXIgLS0-PiBQZXJzaXN0ZWREYXRhU2VyaWFsaXplcjogc2VyaWFsaXplciBvYmplY3Qgd2l0aCBgVHlwZUhhbmRsZXJgXG4gICAgICBQZXJzaXN0ZWREYXRhU2VyaWFsaXplciAtLT4-IFNlcmlhbGl6ZXI6IHJldHVybnMgYFBlcnNpc3RlZERhdGFgXG4gICAgICBTZXJpYWxpemVyIC0tPj4gUGVyc2lzdGVkRGF0YVdyaXRlcjogd3JpdGUgYFBlcnNpc3RlZERhdGFgIHRvIGBvdXRwdXRgXG4gICAgICBQZXJzaXN0ZWREYXRhV3JpdGVyIC0tPj4gU2VyaWFsaXplcjogb3B0aW9uYWw6IHJldHVybnMgYGJ5dGVbXWAgb3IgYHZvaWRgXG4gICAgICBTZXJpYWxpemVyIC0tPj4gWU9VOiBvcHRpb25hbDogcmV0dXJucyBgYnl0ZVtdYCBvciBgdm9pZGBcbiIsIm1lcm1haWQiOnt9LCJ1cGRhdGVFZGl0b3IiOmZhbHNlfQ)
Deserialization:
[![](https://mermaid.ink/img/eyJjb2RlIjoic2VxdWVuY2VEaWFncmFtXG4gICAgICBZT1UgLS0-PiBTZXJpYWxpemVyOiBEZXNlcml6YWxpemUgTXkgT2JqZWN0IGluIGBvdXRwdXRgXG4gICAgICBTZXJpYWxpemVyIC0tPj4gVHlwZUhhbmRsZXJMaWJyYXJ5OiBHaXZlIE1lIGBUeXBlSGFuZGxlcmAgZm9yIHRoaXMgT2JqZWN0XG4gICAgICBUeXBlSGFuZGxlckxpYnJhcnkgLS0-PiBUeXBlSGFuZGxlckxpYnJhcnk6IGZpbmRpbmcgYFR5cGVIYW5kbGVyRmFjdG9yeWAgaW4gc3RvcmVcbiAgICAgIFR5cGVIYW5kbGVyTGlicmFyeSAtLT4-IFR5cGVIYW5kbGVyRmFjdG9yeTogR2l2ZSBNZSBgVHlwZUhhbmRsZXJgXG4gICAgICBUeXBlSGFuZGxlckZhY3RvcnkgLS0-PiBUeXBlSGFuZGxlckxpYnJhcnk6IHJldHVybnMgYFR5cGVIYW5kbGVyYFxuICAgICAgVHlwZUhhbmRsZXJMaWJyYXJ5IC0tPj4gU2VyaWFsaXplcjogIHJldHVybnMgYFR5cGVIYW5kbGVyYFxuICAgICAgU2VyaWFsaXplciAtLT4-IFBlcnNpc3RlZERhdGFTZXJpYWxpemVyOiBkZXNlcmlhbGl6ZSBvYmplY3Qgd2l0aCBgVHlwZUhhbmRsZXJgXG4gICAgICBQZXJzaXN0ZWREYXRhU2VyaWFsaXplciAtLT4-IFNlcmlhbGl6ZXI6IHJldHVybnMgYFBlcnNpc3RlZERhdGFgXG4gICAgICBTZXJpYWxpemVyIC0tPj4gUGVyc2lzdGVkRGF0YVJlYWRlcjogd3JpdGUgYFBlcnNpc3RlZERhdGFgIGZyb20gJ2lucHV0J1xuICAgICAgUGVyc2lzdGVkRGF0YVJlYWRlciAtLT4-IFNlcmlhbGl6ZXI6IHJldHVybnMgZGVzZXJpYWxpemVkIG9iamVjXG4gICAgICBTZXJpYWxpemVyIC0tPj4gWU9VOiByZXR1cm5zIGRlc2VyaWFsaXplZCBvYmplY1xuIiwibWVybWFpZCI6e30sInVwZGF0ZUVkaXRvciI6ZmFsc2V9)](https://mermaid-js.github.io/mermaid-live-editor/#/edit/eyJjb2RlIjoic2VxdWVuY2VEaWFncmFtXG4gICAgICBZT1UgLS0-PiBTZXJpYWxpemVyOiBEZXNlcml6YWxpemUgTXkgT2JqZWN0IGluIGBvdXRwdXRgXG4gICAgICBTZXJpYWxpemVyIC0tPj4gVHlwZUhhbmRsZXJMaWJyYXJ5OiBHaXZlIE1lIGBUeXBlSGFuZGxlcmAgZm9yIHRoaXMgT2JqZWN0XG4gICAgICBUeXBlSGFuZGxlckxpYnJhcnkgLS0-PiBUeXBlSGFuZGxlckxpYnJhcnk6IGZpbmRpbmcgYFR5cGVIYW5kbGVyRmFjdG9yeWAgaW4gc3RvcmVcbiAgICAgIFR5cGVIYW5kbGVyTGlicmFyeSAtLT4-IFR5cGVIYW5kbGVyRmFjdG9yeTogR2l2ZSBNZSBgVHlwZUhhbmRsZXJgXG4gICAgICBUeXBlSGFuZGxlckZhY3RvcnkgLS0-PiBUeXBlSGFuZGxlckxpYnJhcnk6IHJldHVybnMgYFR5cGVIYW5kbGVyYFxuICAgICAgVHlwZUhhbmRsZXJMaWJyYXJ5IC0tPj4gU2VyaWFsaXplcjogIHJldHVybnMgYFR5cGVIYW5kbGVyYFxuICAgICAgU2VyaWFsaXplciAtLT4-IFBlcnNpc3RlZERhdGFTZXJpYWxpemVyOiBkZXNlcmlhbGl6ZSBvYmplY3Qgd2l0aCBgVHlwZUhhbmRsZXJgXG4gICAgICBQZXJzaXN0ZWREYXRhU2VyaWFsaXplciAtLT4-IFNlcmlhbGl6ZXI6IHJldHVybnMgYFBlcnNpc3RlZERhdGFgXG4gICAgICBTZXJpYWxpemVyIC0tPj4gUGVyc2lzdGVkRGF0YVJlYWRlcjogd3JpdGUgYFBlcnNpc3RlZERhdGFgIGZyb20gJ2lucHV0J1xuICAgICAgUGVyc2lzdGVkRGF0YVJlYWRlciAtLT4-IFNlcmlhbGl6ZXI6IHJldHVybnMgZGVzZXJpYWxpemVkIG9iamVjXG4gICAgICBTZXJpYWxpemVyIC0tPj4gWU9VOiByZXR1cm5zIGRlc2VyaWFsaXplZCBvYmplY1xuIiwibWVybWFpZCI6e30sInVwZGF0ZUVkaXRvciI6ZmFsc2V9)


##### Implement your own format
You should implements:
1. `PersistedData` - for storing your format data.
2. `PersistedDataSerializer` - for creating your `PersistedData` from `TypeHandler`
3. `PersistedDataWriter` - for writing your `PersistedData` to outputStream or bytes 
4. `PersistedDataReader` - for reading your `PersistedData` from inputStream or bytes
 
##### Implement your own handler for java type
Just implement `TypeHandler` and register it in `TypeHandlerLibrary`

Example( `BooleanTypeHandler` from coreTypes ):
```java
public class BooleanTypeHandler extends TypeHandler<Boolean> {

    @Override
    public PersistedData serializeNonNull(Boolean value, PersistedDataSerializer serializer) {
        return serializer.serialize(value);
    }

    @Override
    public Optional<Boolean> deserialize(PersistedData data) {
        if (data.isBoolean()) {
            return Optional.of(data.getAsBoolean());
        }
        return Optional.empty();
    }

}
```

Or implement `TypeHandlerFactory` and register it in `TypeHandlerLibrary`
 