// Copyright 2021 The Terasology Foundation
// SPDX-License-Identifier: Apache-2.0

package org.terasology.engine.unicode;

/**
 * Unicode Enclosed Alphanumerics block with renderable characters from u2460 to u24FF. Unicode 4.1.0.
 */
public final class EnclosedAlphanumerics {
   public static final char CIRCLED_DIGIT_ONE = '\u2460';
   public static final char CIRCLED_DIGIT_TWO = '\u2461';
   public static final char CIRCLED_DIGIT_THREE = '\u2462';
   public static final char CIRCLED_DIGIT_FOUR = '\u2463';
   public static final char CIRCLED_DIGIT_FIVE = '\u2464';
   public static final char CIRCLED_DIGIT_SIX = '\u2465';
   public static final char CIRCLED_DIGIT_SEVEN = '\u2466';
   public static final char CIRCLED_DIGIT_EIGHT = '\u2467';
   public static final char CIRCLED_DIGIT_NINE = '\u2468';
   public static final char CIRCLED_NUMBER_TEN = '\u2469';
   public static final char CIRCLED_NUMBER_ELEVEN = '\u246A';
   public static final char CIRCLED_NUMBER_TWELVE = '\u246B';
   public static final char CIRCLED_NUMBER_THIRTEEN = '\u246C';
   public static final char CIRCLED_NUMBER_FOURTEEN = '\u246D';
   public static final char CIRCLED_NUMBER_FIFTEEN = '\u246E';
   public static final char CIRCLED_NUMBER_SIXTEEN = '\u246F';
   public static final char CIRCLED_NUMBER_SEVENTEEN = '\u2470';
   public static final char CIRCLED_NUMBER_EIGHTEEN = '\u2471';
   public static final char CIRCLED_NUMBER_NINETEEN = '\u2472';
   public static final char CIRCLED_NUMBER_TWENTY = '\u2473';
//   public static final char PARENTHESIZED_DIGIT_ONE = '\u2474';
//   public static final char PARENTHESIZED_DIGIT_TWO = '\u2475';
//   public static final char PARENTHESIZED_DIGIT_THREE = '\u2476';
//   public static final char PARENTHESIZED_DIGIT_FOUR = '\u2477';
//   public static final char PARENTHESIZED_DIGIT_FIVE = '\u2478';
//   public static final char PARENTHESIZED_DIGIT_SIX = '\u2479';
//   public static final char PARENTHESIZED_DIGIT_SEVEN = '\u247A';
//   public static final char PARENTHESIZED_DIGIT_EIGHT = '\u247B';
//   public static final char PARENTHESIZED_DIGIT_NINE = '\u247C';
//   public static final char PARENTHESIZED_NUMBER_TEN = '\u247D';
//   public static final char PARENTHESIZED_NUMBER_ELEVEN = '\u247E';
//   public static final char PARENTHESIZED_NUMBER_TWELVE = '\u247F';
//   public static final char PARENTHESIZED_NUMBER_THIRTEEN = '\u2480';
//   public static final char PARENTHESIZED_NUMBER_FOURTEEN = '\u2481';
//   public static final char PARENTHESIZED_NUMBER_FIFTEEN = '\u2482';
//   public static final char PARENTHESIZED_NUMBER_SIXTEEN = '\u2483';
//   public static final char PARENTHESIZED_NUMBER_SEVENTEEN = '\u2484';
//   public static final char PARENTHESIZED_NUMBER_EIGHTEEN = '\u2485';
//   public static final char PARENTHESIZED_NUMBER_NINETEEN = '\u2486';
//   public static final char PARENTHESIZED_NUMBER_TWENTY = '\u2487';
//   public static final char DIGIT_ONE_PERIOD = '\u2488';
//   public static final char DIGIT_TWO_PERIOD = '\u2489';
//   public static final char DIGIT_THREE_PERIOD = '\u248A';
//   public static final char DIGIT_FOUR_PERIOD = '\u248B';
//   public static final char DIGIT_FIVE_PERIOD = '\u248C';
//   public static final char DIGIT_SIX_PERIOD = '\u248D';
//   public static final char DIGIT_SEVEN_PERIOD = '\u248E';
//   public static final char DIGIT_EIGHT_PERIOD = '\u248F';
//   public static final char DIGIT_NINE_PERIOD = '\u2490';
//   public static final char NUMBER_TEN_PERIOD = '\u2491';
//   public static final char NUMBER_ELEVEN_PERIOD = '\u2492';
//   public static final char NUMBER_TWELVE_PERIOD = '\u2493';
//   public static final char NUMBER_THIRTEEN_PERIOD = '\u2494';
//   public static final char NUMBER_FOURTEEN_PERIOD = '\u2495';
//   public static final char NUMBER_FIFTEEN_PERIOD = '\u2496';
//   public static final char NUMBER_SIXTEEN_PERIOD = '\u2497';
//   public static final char NUMBER_SEVENTEEN_PERIOD = '\u2498';
//   public static final char NUMBER_EIGHTEEN_PERIOD = '\u2499';
//   public static final char NUMBER_NINETEEN_PERIOD = '\u249A';
//   public static final char NUMBER_TWENTY_PERIOD = '\u249B';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_A = '\u249C';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_B = '\u249D';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_C = '\u249E';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_D = '\u249F';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_E = '\u24A0';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_F = '\u24A1';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_G = '\u24A2';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_H = '\u24A3';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_I = '\u24A4';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_J = '\u24A5';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_K = '\u24A6';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_L = '\u24A7';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_M = '\u24A8';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_N = '\u24A9';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_O = '\u24AA';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_P = '\u24AB';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_Q = '\u24AC';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_R = '\u24AD';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_S = '\u24AE';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_T = '\u24AF';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_U = '\u24B0';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_V = '\u24B1';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_W = '\u24B2';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_X = '\u24B3';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_Y = '\u24B4';
//   public static final char PARENTHESIZED_LATIN_SMALL_LETTER_Z = '\u24B5';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_A = '\u24B6';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_B = '\u24B7';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_C = '\u24B8';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_D = '\u24B9';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_E = '\u24BA';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_F = '\u24BB';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_G = '\u24BC';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_H = '\u24BD';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_I = '\u24BE';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_J = '\u24BF';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_K = '\u24C0';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_L = '\u24C1';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_M = '\u24C2';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_N = '\u24C3';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_O = '\u24C4';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_P = '\u24C5';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_Q = '\u24C6';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_R = '\u24C7';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_S = '\u24C8';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_T = '\u24C9';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_U = '\u24CA';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_V = '\u24CB';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_W = '\u24CC';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_X = '\u24CD';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_Y = '\u24CE';
   public static final char CIRCLED_LATIN_CAPITAL_LETTER_Z = '\u24CF';
   public static final char CIRCLED_LATIN_SMALL_LETTER_A = '\u24D0';
   public static final char CIRCLED_LATIN_SMALL_LETTER_B = '\u24D1';
   public static final char CIRCLED_LATIN_SMALL_LETTER_C = '\u24D2';
   public static final char CIRCLED_LATIN_SMALL_LETTER_D = '\u24D3';
   public static final char CIRCLED_LATIN_SMALL_LETTER_E = '\u24D4';
   public static final char CIRCLED_LATIN_SMALL_LETTER_F = '\u24D5';
   public static final char CIRCLED_LATIN_SMALL_LETTER_G = '\u24D6';
   public static final char CIRCLED_LATIN_SMALL_LETTER_H = '\u24D7';
   public static final char CIRCLED_LATIN_SMALL_LETTER_I = '\u24D8';
   public static final char CIRCLED_LATIN_SMALL_LETTER_J = '\u24D9';
   public static final char CIRCLED_LATIN_SMALL_LETTER_K = '\u24DA';
   public static final char CIRCLED_LATIN_SMALL_LETTER_L = '\u24DB';
   public static final char CIRCLED_LATIN_SMALL_LETTER_M = '\u24DC';
   public static final char CIRCLED_LATIN_SMALL_LETTER_N = '\u24DD';
   public static final char CIRCLED_LATIN_SMALL_LETTER_O = '\u24DE';
   public static final char CIRCLED_LATIN_SMALL_LETTER_P = '\u24DF';
   public static final char CIRCLED_LATIN_SMALL_LETTER_Q = '\u24E0';
   public static final char CIRCLED_LATIN_SMALL_LETTER_R = '\u24E1';
   public static final char CIRCLED_LATIN_SMALL_LETTER_S = '\u24E2';
   public static final char CIRCLED_LATIN_SMALL_LETTER_T = '\u24E3';
   public static final char CIRCLED_LATIN_SMALL_LETTER_U = '\u24E4';
   public static final char CIRCLED_LATIN_SMALL_LETTER_V = '\u24E5';
   public static final char CIRCLED_LATIN_SMALL_LETTER_W = '\u24E6';
   public static final char CIRCLED_LATIN_SMALL_LETTER_X = '\u24E7';
   public static final char CIRCLED_LATIN_SMALL_LETTER_Y = '\u24E8';
   public static final char CIRCLED_LATIN_SMALL_LETTER_Z = '\u24E9';
   public static final char CIRCLED_DIGIT_ZERO = '\u24EA';
//   public static final char NEGATIVE_CIRCLED_NUMBER_ELEVEN = '\u24EB';
//   public static final char NEGATIVE_CIRCLED_NUMBER_TWELVE = '\u24EC';
//   public static final char NEGATIVE_CIRCLED_NUMBER_THIRTEEN = '\u24ED';
//   public static final char NEGATIVE_CIRCLED_NUMBER_FOURTEEN = '\u24EE';
//   public static final char NEGATIVE_CIRCLED_NUMBER_FIFTEEN = '\u24EF';
//   public static final char NEGATIVE_CIRCLED_NUMBER_SIXTEEN = '\u24F0';
//   public static final char NEGATIVE_CIRCLED_NUMBER_SEVENTEEN = '\u24F1';
//   public static final char NEGATIVE_CIRCLED_NUMBER_EIGHTEEN = '\u24F2';
//   public static final char NEGATIVE_CIRCLED_NUMBER_NINETEEN = '\u24F3';
//   public static final char NEGATIVE_CIRCLED_NUMBER_TWENTY = '\u24F4';
//   public static final char DOUBLE_CIRCLED_DIGIT_ONE = '\u24F5';
//   public static final char DOUBLE_CIRCLED_DIGIT_TWO = '\u24F6';
//   public static final char DOUBLE_CIRCLED_DIGIT_THREE = '\u24F7';
//   public static final char DOUBLE_CIRCLED_DIGIT_FOUR = '\u24F8';
//   public static final char DOUBLE_CIRCLED_DIGIT_FIVE = '\u24F9';
//   public static final char DOUBLE_CIRCLED_DIGIT_SIX = '\u24FA';
//   public static final char DOUBLE_CIRCLED_DIGIT_SEVEN = '\u24FB';
//   public static final char DOUBLE_CIRCLED_DIGIT_EIGHT = '\u24FC';
//   public static final char DOUBLE_CIRCLED_DIGIT_NINE = '\u24FD';
//   public static final char DOUBLE_CIRCLED_NUMBER_TEN = '\u24FE';
//   public static final char NEGATIVE_CIRCLED_DIGIT_ZERO = '\u24FF';

   private EnclosedAlphanumerics() {
       // no instances
   }
}
