/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.gradle.wrapper.BootstrapMainStarter;

public class GroovyBootstrapMainStarter
extends BootstrapMainStarter {
    public void start(String[] args, File gradleHome) throws Exception {
        URL[] urls = new URL[]{this.findJar("groovy-all", gradleHome, "lib"), this.findJar("ivy", gradleHome, "lib/plugins"), this.findJar("junit", gradleHome, "lib/plugins")};
        try (URLClassLoader contextClassLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader().getParent());){
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            Class<?> mainClass = contextClassLoader.loadClass("groovy.ui.GroovyMain");
            Method mainMethod = mainClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
        }
    }

    private URL findJar(String fragment, File gradleHome, String subdir) {
        File gradleSubdir = new File(gradleHome, subdir);
        File[] files = gradleSubdir.listFiles((d, name) -> name.startsWith(fragment + "-") && name.endsWith(".jar"));
        if (files == null) {
            throw new RuntimeException(String.format("Could not locate the JAR for %s; no such directory '%s'.", fragment, gradleSubdir));
        }
        if (files.length == 0) {
            throw new RuntimeException(String.format("Could not locate the JAR for %s in Gradle distribution '%s'.", fragment, gradleHome));
        }
        try {
            return files[0].toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

