/**
 * This file is part of alf.io.
 *
 * alf.io is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * alf.io is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with alf.io.  If not, see <http://www.gnu.org/licenses/>.
 */
package alfio.repository;

import alfio.model.AdditionalServiceItem;
import alfio.model.AdditionalServiceItem.AdditionalServiceItemStatus;
import ch.digitalfondue.npjt.*;

import java.time.ZonedDateTime;
import java.util.List;

@QueryRepository
public interface AdditionalServiceItemRepository {

    @Query("insert into additional_service_item (uuid, creation, tickets_reservation_uuid, additional_service_id_fk, status, event_id_fk, src_price_cts, final_price_cts, vat_cts, discount_cts) " +
        "values(:uuid, :creation, :ticketsReservationUuid, :additionalServiceId, :status, :eventId, :srcPriceCts, :finalPriceCts, :vatCts, :discountCts)")
    @AutoGeneratedKey("id")
    AffectedRowCountAndKey<Integer> insert(@Bind("uuid") String uuid, @Bind("creation") ZonedDateTime creation, @Bind("ticketsReservationUuid") String ticketsReservationUuid,
                                           @Bind("additionalServiceId") int additionalServiceId, @Bind("status") AdditionalServiceItemStatus status, @Bind("eventId") int eventId,
                                           @Bind("srcPriceCts") Integer srcPriceCts, @Bind("finalPriceCts") Integer finalPriceCts, @Bind("vatCts") Integer vatCts, @Bind("discountCts") Integer discountCts);

    @Query("select * from additional_service_item where tickets_reservation_uuid = :reservationUuid")
    List<AdditionalServiceItem> findByReservationUuid(@Bind("reservationUuid") String reservationUuid);

    @Query("update additional_service_item set status = :status where tickets_reservation_uuid = :reservationUuid")
    int updateItemsStatusWithReservationUUID(@Bind("reservationUuid") String reservationUuid, @Bind("status") AdditionalServiceItemStatus status);

    @Query("select count(*) > 0 from additional_service_item " +
        " inner join additional_service on additional_service_id_fk = additional_service.id " +
        " where service_type = 'SUPPLEMENT' and tickets_reservation_uuid = :reservationId and final_price_cts > 0")
    boolean hasPaidSupplements(@Bind("reservationId") String reservationId);

}
