/**
 * This file is part of alf.io.
 *
 * alf.io is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * alf.io is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with alf.io.  If not, see <http://www.gnu.org/licenses/>.
 */
package alfio.manager.support;

import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper.Column;
import lombok.Getter;

import java.util.Date;

@Getter
public class CheckInStatistics {
    private final int totalAttendees;
    private final int checkedIn;
    private final long lastUpdate;



    public CheckInStatistics(@Column("total_attendees") Integer totalAttendees,
                             @Column("checked_in") Integer checkedIn,
                             @Column("last_update") Date lastUpdate) {
        this.totalAttendees = totalAttendees;
        this.checkedIn = checkedIn;
        this.lastUpdate = lastUpdate.getTime();
    }
}
