# Contributing to Pro Git (2nd Edition)

## Licensing your work to us

When you open a pull request, you agree to provide your work under the [project license](LICENSE.asc).
Also, you agree to grant such license of your work as is required for the purposes of future print editions to @ben and @schacon.
Should your changes appear in a printed edition, you'll be included in the [contributors list](book/contributors.asc).

## Signaling an Issue

Search for similar issues, before creating a new issue.

Also, if this issue has been spotted on the git-scm.com site, cross-check that the issue is present in the pdf version.
The issue may have already been corrected in the source files, but not yet deployed to the git-scm.com site.

## Small Corrections

Errata and basic clarifications will be accepted if we agree that they improve the content.
You can also open an issue so that we can discuss how or if the issue needs to be addressed.

If you've never done this before, the [flow guide](https://guides.github.com/introduction/flow/) might be useful.

## Large Rewrites

Open an issue for discussion before you start.
A large rewrite tends to be very subjective, often only clarifying things for a small amount of readers.
Professional copy editors have already reviewed this content multiple times.
It's unlikely that your prose is going to be *so* much better that it's worth changing large portions of text.

## Figures

The images in this book are generated using [Sketch 3](https://www.sketchapp.com/), with the [included sketchbook file](diagram-source/progit.sketch).

To create a figure:

1. Add a page to the sketchbook.
Use the included symbols wherever possible.
2. Add a "slice" to your page.
Name the slice so that it matches the destination PNG filename, relative from the root of the source directory.
3. Set your slice to export at "800w".

## Translations

If you want to contribute to translating Pro Git into your language, take a look at [TRANSLATING.md](TRANSLATING.md).
