/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceParser;
import com.android.utils.ILogger;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.Closeables;
import java.io.InputStream;

public class VendorDevices {
    private static final String[] DEVICE_FILES = new String[]{"nexus", "wear", "tv", "automotive", "desktop"};
    private final ILogger mLog;
    private Table<String, String, Device> mVendorDevices;
    private final Object mLock = new Object();

    public VendorDevices(ILogger log) {
        this.mLog = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVendorDevices != null) {
                return false;
            }
            this.mVendorDevices = HashBasedTable.create();
            boolean hasChanged = false;
            for (String deviceFile : DEVICE_FILES) {
                InputStream stream = VendorDevices.class.getResourceAsStream(deviceFile + ".xml");
                try {
                    this.mVendorDevices.putAll(DeviceParser.parse(stream));
                    hasChanged = true;
                }
                catch (Exception e) {
                    this.mLog.error((Throwable)e, "Could not load " + deviceFile + " devices", new Object[0]);
                }
                finally {
                    Closeables.closeQuietly((InputStream)stream);
                }
            }
            return hasChanged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device getDevice(String id, String manufacturer) {
        Object object = this.mLock;
        synchronized (object) {
            return (Device)this.mVendorDevices.get((Object)id, (Object)manufacturer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table<String, String, Device> getDevices() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mVendorDevices;
        }
    }
}

