/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.model.AbstractFunctor;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.SimpleEffect;
import org.jetbrains.kotlin.contracts.model.structure.ESCalls;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.contracts.model.visitors.Reducer;
import org.jetbrains.kotlin.contracts.model.visitors.Substitutor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\f\u0010\u0016\u001a\u00020\u0011*\u00020\u0017H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/SubstitutingFunctor;", "Lorg/jetbrains/kotlin/contracts/model/AbstractFunctor;", "basicEffects", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "ownerFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "doInvocation", "arguments", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "typeSubstitution", "Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "reducer", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "computeParameters", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "combine", "effect", "Lorg/jetbrains/kotlin/contracts/model/SimpleEffect;", "substitutedCondition", "toESVariable", "Lorg/jetbrains/kotlin/descriptors/ValueDescriptor;", "resolution"})
@SourceDebugExtension(value={"SMAP\nSubstitutingFunctor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubstitutingFunctor.kt\norg/jetbrains/kotlin/contracts/model/functors/SubstitutingFunctor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1863#2,2:107\n1557#2:109\n1628#2,3:110\n1#3:113\n*S KotlinDebug\n*F\n+ 1 SubstitutingFunctor.kt\norg/jetbrains/kotlin/contracts/model/functors/SubstitutingFunctor\n*L\n45#1:107,2\n65#1:109\n65#1:110,3\n*E\n"})
public final class SubstitutingFunctor
extends AbstractFunctor {
    @NotNull
    private final List<ESEffect> basicEffects;
    @NotNull
    private final FunctionDescriptor ownerFunction;

    public SubstitutingFunctor(@NotNull List<? extends ESEffect> basicEffects, @NotNull FunctionDescriptor ownerFunction) {
        Intrinsics.checkNotNullParameter(basicEffects, (String)"basicEffects");
        Intrinsics.checkNotNullParameter((Object)ownerFunction, (String)"ownerFunction");
        this.basicEffects = basicEffects;
        this.ownerFunction = ownerFunction;
    }

    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments, @NotNull ESTypeSubstitution typeSubstitution, @NotNull Reducer reducer) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)typeSubstitution, (String)"typeSubstitution");
        Intrinsics.checkNotNullParameter((Object)reducer, (String)"reducer");
        if (this.basicEffects.isEmpty()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        List<ESVariable> parameters = this.computeParameters(arguments);
        Map substitutions = MapsKt.toMap((Iterable)kotlin.collections.CollectionsKt.zip((Iterable)parameters, (Iterable)arguments));
        Substitutor substitutor2 = new Substitutor(substitutions, typeSubstitution, reducer);
        List substitutedClauses = new ArrayList();
        for (ESEffect effect : this.basicEffects) {
            ESEffect eSEffect = effect;
            if (eSEffect instanceof ConditionalEffect) {
                Object object = (Computation)((ConditionalEffect)effect).getCondition().accept(substitutor2);
                if (object != null && (object = object.getEffects()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ESEffect it = (ESEffect)element$iv;
                        boolean bl = false;
                        CollectionsKt.addIfNotNull(substitutedClauses, this.combine(((ConditionalEffect)effect).getSimpleEffect(), it));
                    }
                }
                continue;
            }
            if (eSEffect instanceof ESCalls) {
                ESValue substitutionForCallable;
                Object v = substitutions.get(((ESCalls)effect).getCallable());
                if ((v instanceof ESValue ? (ESValue)v : null) == null) continue;
                substitutionForCallable = substitutionForCallable;
                ((Collection)substitutedClauses).add(new ESCalls(substitutionForCallable, ((ESCalls)effect).getKind()));
                continue;
            }
            ((Collection)substitutedClauses).add(effect);
        }
        return substitutedClauses;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ESVariable> computeParameters(List<? extends Computation> arguments) {
        ESVariable it;
        void $this$mapTo$iv$iv;
        ReceiverParameterDescriptor receiverParameterDescriptor = this.ownerFunction.getDispatchReceiverParameter();
        ESVariable dispatchReceiver = receiverParameterDescriptor != null ? this.toESVariable(receiverParameterDescriptor) : null;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = this.ownerFunction.getExtensionReceiverParameter();
        ESVariable extensionReceiver = receiverParameterDescriptor2 != null ? this.toESVariable(receiverParameterDescriptor2) : null;
        Object[] objectArray = new ESVariable[]{dispatchReceiver, extensionReceiver};
        List receivers = kotlin.collections.CollectionsKt.listOfNotNull((Object[])objectArray);
        List<ValueParameterDescriptor> list = this.ownerFunction.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toESVariable((ValueDescriptor)((Object)it)));
        }
        List valueParameters = (List)destination$iv$iv;
        List parameters = kotlin.collections.CollectionsKt.plus((Collection)receivers, (Iterable)valueParameters);
        if (parameters.size() == arguments.size()) {
            return parameters;
        }
        Object object = dispatchReceiver;
        if (object == null || (object = ((ESVariable)object).getDescriptor()) == null) {
            SubstitutingFunctor.computeParameters$fail(arguments, parameters);
            throw new KotlinNothingValueException();
        }
        Object dispatchParameterDescriptor = object;
        if (dispatchParameterDescriptor instanceof ReceiverParameterDescriptor) {
            Object object2 = ((ReceiverParameterDescriptor)dispatchParameterDescriptor).getValue();
            Object object3 = object2 instanceof ImplicitClassReceiver ? (ImplicitClassReceiver)object2 : null;
            if (object3 == null || (object3 = ((ImplicitClassReceiver)object3).getClassDescriptor()) == null) {
                SubstitutingFunctor.computeParameters$fail(arguments, parameters);
                throw new KotlinNothingValueException();
            }
            Object classDescriptor = object3;
            if (classDescriptor.getKind() == ClassKind.OBJECT) {
                Object $this$computeParameters_u24lambda_u243 = object2 = kotlin.collections.CollectionsKt.createListBuilder();
                boolean bl = false;
                ESVariable eSVariable = extensionReceiver;
                if (eSVariable != null) {
                    it = eSVariable;
                    boolean bl2 = false;
                    $this$computeParameters_u24lambda_u243.add(it);
                }
                $this$computeParameters_u24lambda_u243.addAll(valueParameters);
                List parametersWithoutDispatch = kotlin.collections.CollectionsKt.build((List)object2);
                if (parametersWithoutDispatch.size() != arguments.size()) {
                    SubstitutingFunctor.computeParameters$fail(arguments, parameters);
                    throw new KotlinNothingValueException();
                }
                return parametersWithoutDispatch;
            }
        }
        SubstitutingFunctor.computeParameters$fail(arguments, parameters);
        throw new KotlinNothingValueException();
    }

    private final ESEffect combine(SimpleEffect effect, ESEffect substitutedCondition) {
        if (!(substitutedCondition instanceof ConditionalEffect)) {
            return null;
        }
        SimpleEffect effectFromCondition = ((ConditionalEffect)substitutedCondition).getSimpleEffect();
        if (!(effectFromCondition instanceof ESReturns) || ValuesKt.isWildcard(((ESReturns)effectFromCondition).getValue())) {
            return substitutedCondition;
        }
        if (!ValuesKt.isTrue(((ESReturns)effectFromCondition).getValue())) {
            return null;
        }
        return new ConditionalEffect(((ConditionalEffect)substitutedCondition).getCondition(), effect);
    }

    private final ESVariable toESVariable(ValueDescriptor $this$toESVariable) {
        return new ESVariable($this$toESVariable);
    }

    private static final Void computeParameters$fail(List<? extends Computation> $arguments, List<? extends ESVariable> parameters) {
        throw new IllegalStateException(("Arguments and parameters size mismatch: arguments.size = " + $arguments.size() + ", parameters.size = " + parameters.size()).toString());
    }
}

