/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanSet;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanSpliterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class BooleanArraySet
extends AbstractBooleanSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected transient boolean[] a;
    protected int size;

    public BooleanArraySet(boolean[] a) {
        this.a = a;
        this.size = a.length;
    }

    public BooleanArraySet() {
        this.a = BooleanArrays.EMPTY_ARRAY;
    }

    private int findKey(boolean o) {
        boolean[] a = this.a;
        int i = this.size;
        while (i-- != 0) {
            if (a[i] != o) continue;
            return i;
        }
        return -1;
    }

    @Override
    public BooleanIterator iterator() {
        return new BooleanIterator(){
            int curr = -1;
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < BooleanArraySet.this.size;
            }

            @Override
            public boolean nextBoolean() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.curr = this.next++;
                return BooleanArraySet.this.a[this.curr];
            }

            @Override
            public void remove() {
                if (this.curr == -1) {
                    throw new IllegalStateException();
                }
                this.curr = -1;
                int tail = BooleanArraySet.this.size-- - this.next--;
                System.arraycopy(BooleanArraySet.this.a, this.next + 1, BooleanArraySet.this.a, this.next, tail);
            }

            @Override
            public void forEachRemaining(BooleanConsumer action2) {
                boolean[] a = BooleanArraySet.this.a;
                while (this.next < BooleanArraySet.this.size) {
                    action2.accept(a[this.next++]);
                }
            }
        };
    }

    @Override
    public BooleanSpliterator spliterator() {
        return new Spliterator();
    }

    @Override
    public boolean contains(boolean k) {
        return this.findKey(k) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(boolean k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        int tail = this.size - pos - 1;
        for (int i = 0; i < tail; ++i) {
            this.a[pos + i] = this.a[pos + i + 1];
        }
        --this.size;
        return true;
    }

    @Override
    public boolean add(boolean k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            boolean[] b = new boolean[this.size == 0 ? 2 : this.size * 2];
            int i = this.size;
            while (i-- != 0) {
                b[i] = this.a[i];
            }
            this.a = b;
        }
        this.a[this.size++] = k;
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean[] toBooleanArray() {
        if (this.size == 0) {
            return BooleanArrays.EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.a, this.size);
    }

    @Override
    public boolean[] toArray(boolean[] a) {
        if (a == null || a.length < this.size) {
            a = new boolean[this.size];
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        return a;
    }

    public BooleanArraySet clone() {
        BooleanArraySet c;
        try {
            c = (BooleanArraySet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.a = (boolean[])this.a.clone();
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        boolean[] a = this.a;
        for (int i = 0; i < this.size; ++i) {
            s.writeBoolean(a[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new boolean[this.size];
        boolean[] a = this.a;
        for (int i = 0; i < this.size; ++i) {
            a[i] = s.readBoolean();
        }
    }

    private final class Spliterator
    implements BooleanSpliterator {
        boolean hasSplit = false;
        int pos;
        int max;

        public Spliterator() {
            this(0, booleanArraySet.size, false);
        }

        private Spliterator(int pos, int max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private int getWorkingMax() {
            return this.hasSplit ? this.max : BooleanArraySet.this.size;
        }

        @Override
        public int characteristics() {
            return 16721;
        }

        @Override
        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        @Override
        public boolean tryAdvance(BooleanConsumer action2) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action2.accept(BooleanArraySet.this.a[this.pos++]);
            return true;
        }

        @Override
        public void forEachRemaining(BooleanConsumer action2) {
            boolean[] a = BooleanArraySet.this.a;
            int max = this.getWorkingMax();
            while (this.pos < max) {
                action2.accept(a[this.pos]);
                ++this.pos;
            }
        }

        @Override
        public BooleanSpliterator trySplit() {
            int myNewPos;
            int max = this.getWorkingMax();
            int retLen = max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            this.max = max;
            int retMax = myNewPos = this.pos + retLen;
            int oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

