/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.PropertyCollector;
import com.intellij.util.xmlb.BeanBindingKt;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/xmlb/XmlSerializerPropertyCollectorListClassValue;", "Ljava/lang/ClassValue;", "", "Lcom/intellij/serialization/MutableAccessor;", "configuration", "Lcom/intellij/serialization/PropertyCollector$Configuration;", "<init>", "(Lcom/intellij/serialization/PropertyCollector$Configuration;)V", "computeValue", "aClass", "Ljava/lang/Class;", "intellij.platform.util"})
final class XmlSerializerPropertyCollectorListClassValue
extends ClassValue<List<? extends MutableAccessor>> {
    @NotNull
    private final PropertyCollector.Configuration configuration;

    public XmlSerializerPropertyCollectorListClassValue(@NotNull PropertyCollector.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
    }

    @Override
    @NotNull
    protected List<MutableAccessor> computeValue(@NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        List<MutableAccessor> list = PropertyCollector.doCollect(aClass, this.configuration, null);
        Intrinsics.checkNotNullExpressionValue(list, (String)"doCollect(...)");
        List<MutableAccessor> result2 = list;
        if (!((Collection)result2).isEmpty() || BeanBindingKt.access$isAssertBindings(aClass)) {
            return result2;
        }
        if (JDOMExternalizable.class.isAssignableFrom(aClass)) {
            BeanBindingKt.LOG.error("Do not compute bindings for JDOMExternalizable: " + aClass.getName());
        } else if (aClass.isEnum()) {
            BeanBindingKt.LOG.error("Do not compute bindings for enum: " + aClass.getName());
        } else if (aClass == String.class) {
            BeanBindingKt.LOG.error("Do not compute bindings for String");
        }
        BeanBindingKt.LOG.debug("No accessors for " + aClass.getName() + ". This means that state class cannot be serialized properly. Please see https://jb.gg/ij-psoc");
        List<MutableAccessor> list2 = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList(...)");
        return list2;
    }
}

