/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.xmlb.XIncludeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDOMXIncluder {
    private static final Logger LOG = Logger.getInstance(JDOMXIncluder.class);
    public static final PathResolver DEFAULT_PATH_RESOLVER = new PathResolver(){

        @Override
        @NotNull
        public URL resolvePath(@NotNull String relativePath, @Nullable URL base) throws MalformedURLException {
            if (relativePath == null) {
                1.$$$reportNull$$$0(0);
            }
            return base == null ? new URL(relativePath) : new URL(base, relativePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/util/xmlb/JDOMXIncluder$1", "resolvePath"));
        }
    };
    private final boolean ignoreMissing;
    private final PathResolver pathResolver;
    @Nullable
    private final String pointer;

    private JDOMXIncluder(boolean ignoreMissing, @NotNull PathResolver pathResolver, @Nullable String defaultPointer) {
        if (pathResolver == null) {
            JDOMXIncluder.$$$reportNull$$$0(0);
        }
        this.ignoreMissing = ignoreMissing;
        this.pathResolver = pathResolver;
        this.pointer = defaultPointer;
    }

    @NotNull
    private List<Element> resolveXIncludeElement(@NotNull Element element, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        String parseAttribute;
        if (element == null) {
            JDOMXIncluder.$$$reportNull$$$0(1);
        }
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(2);
        }
        URL base = null;
        if (!bases.isEmpty()) {
            base = bases.peek();
        }
        String href = element.getAttributeValue("href");
        assert (href != null) : "Missing href attribute";
        String baseAttribute = element.getAttributeValue("base", Namespace.XML_NAMESPACE);
        if (baseAttribute != null) {
            base = new URL(baseAttribute);
        }
        if ((parseAttribute = element.getAttributeValue("parse")) != null) {
            LOG.assertTrue(parseAttribute.equals("xml"), parseAttribute + " is not a legal value for the parse attribute");
        }
        URL remote = this.pathResolver.resolvePath(href, base);
        assert (!bases.contains(remote)) : "Circular XInclude Reference to " + remote.toExternalForm();
        Element fallbackElement = element.getChild("fallback", element.getNamespace());
        List<Element> remoteParsed = this.parseRemote(bases, remote, fallbackElement);
        if (!remoteParsed.isEmpty()) {
            remoteParsed = JDOMXIncluder.extractNeededChildren(element, remoteParsed, this.pointer);
        }
        for (int i = 0; i < remoteParsed.size(); ++i) {
            Element o = remoteParsed.get(i);
            if (JDOMXIncluder.isIncludeElement(o)) {
                List<Element> list = this.resolveXIncludeElement(o, bases);
                remoteParsed.addAll(i, list);
                remoteParsed.remove(i += list.size() - 1);
                continue;
            }
            this.resolveNonXIncludeElement(o, bases);
        }
        for (Content content : remoteParsed) {
            content.detach();
        }
        List<Element> list = remoteParsed;
        if (list == null) {
            JDOMXIncluder.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private List<Element> parseRemote(@NotNull Stack<URL> bases, @NotNull URL remote, @Nullable Element fallbackElement) {
        List<Element> list;
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(4);
        }
        if (remote == null) {
            JDOMXIncluder.$$$reportNull$$$0(5);
        }
        try {
            bases.push(remote);
            Element root = JDOMUtil.loadResource(remote);
            List<Element> list2 = this.resolve(root, bases);
            list = list2;
        }
        catch (JDOMException e) {
            throw new XIncludeException(e);
        }
        catch (IOException e) {
            if (fallbackElement != null) {
                List<Element> list3 = Collections.emptyList();
                List<Element> list4 = list3;
                if (list4 == null) {
                    JDOMXIncluder.$$$reportNull$$$0(7);
                }
                return list4;
            }
            if (this.ignoreMissing) {
                LOG.info(remote.toExternalForm() + " include ignored: " + e.getMessage());
                List<Element> list5 = Collections.emptyList();
                List<Element> list6 = list5;
                if (list6 == null) {
                    JDOMXIncluder.$$$reportNull$$$0(8);
                }
                return list6;
            }
            throw new XIncludeException(e);
        }
        finally {
            bases.pop();
        }
        if (list == null) {
            JDOMXIncluder.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private List<Element> doResolve(@NotNull Element original, URL base) throws XIncludeException, MalformedURLException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(9);
        }
        Stack<URL> bases = new Stack<URL>();
        if (base != null) {
            bases.push(base);
        }
        return this.resolve(original, bases);
    }

    private static boolean isIncludeElement(Element element) {
        return element.getName().equals("include") && element.getNamespace().equals(JDOMUtil.XINCLUDE_NAMESPACE);
    }

    @NotNull
    private List<Element> resolve(@NotNull Element original, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(10);
        }
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(11);
        }
        if (JDOMXIncluder.isIncludeElement(original)) {
            return this.resolveXIncludeElement(original, bases);
        }
        this.resolveNonXIncludeElement(original, bases);
        List<Element> list = Collections.singletonList(original);
        if (list == null) {
            JDOMXIncluder.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public static List<Element> resolve(@NotNull Element original, URL base) throws XIncludeException, MalformedURLException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(13);
        }
        return new JDOMXIncluder(false, DEFAULT_PATH_RESOLVER, null).doResolve(original, base);
    }

    @NotNull
    public static List<Element> resolveWithDefaultPluginPointer(@NotNull Element original, URL base) throws XIncludeException, MalformedURLException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(14);
        }
        return new JDOMXIncluder(false, DEFAULT_PATH_RESOLVER, "xpointer(/idea-plugin/*)").doResolve(original, base);
    }

    @NotNull
    private static List<Element> extractNeededChildren(@NotNull Element element, @NotNull List<Element> remoteElements, @Nullable String defaultPointer) {
        String xpointer;
        if (element == null) {
            JDOMXIncluder.$$$reportNull$$$0(15);
        }
        if (remoteElements == null) {
            JDOMXIncluder.$$$reportNull$$$0(16);
        }
        if ((xpointer = element.getAttributeValue("xpointer")) == null) {
            xpointer = defaultPointer;
        }
        if (xpointer == null) {
            List<Element> list = remoteElements;
            if (list == null) {
                JDOMXIncluder.$$$reportNull$$$0(17);
            }
            return list;
        }
        Matcher matcher = JDOMUtil.XPOINTER_PATTERN.matcher(xpointer);
        if (!matcher.matches()) {
            throw new XIncludeException("Unsupported XPointer: " + xpointer);
        }
        String pointer = matcher.group(1);
        if (!(matcher = JDOMUtil.CHILDREN_PATTERN.matcher(pointer)).matches()) {
            throw new XIncludeException("Unsupported pointer: " + pointer);
        }
        String rootTagName = matcher.group(1);
        assert (remoteElements.size() == 1);
        Element e = remoteElements.get(0);
        if (!e.getName().equals(rootTagName)) {
            List<Element> list = Collections.emptyList();
            if (list == null) {
                JDOMXIncluder.$$$reportNull$$$0(18);
            }
            return list;
        }
        String subTagName = matcher.group(2);
        if (subTagName != null) {
            e = e.getChild(subTagName.substring(1));
            assert (e != null);
        }
        return new ArrayList<Element>(e.getChildren());
    }

    private void resolveNonXIncludeElement(@NotNull Element original, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        if (original == null) {
            JDOMXIncluder.$$$reportNull$$$0(19);
        }
        if (bases == null) {
            JDOMXIncluder.$$$reportNull$$$0(20);
        }
        List<Content> contentList = original.getContent();
        for (int i = contentList.size() - 1; i >= 0; --i) {
            Content content = contentList.get(i);
            if (!(content instanceof Element)) continue;
            Element element = (Element)content;
            if (JDOMXIncluder.isIncludeElement(element)) {
                original.setContent(i, this.resolveXIncludeElement(element, bases));
                continue;
            }
            this.resolveNonXIncludeElement(element, bases);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bases";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/JDOMXIncluder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/JDOMXIncluder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveXIncludeElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRemote";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNeededChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveXIncludeElement";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 18: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseRemote";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithDefaultPluginPointer";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractNeededChildren";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveNonXIncludeElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PathResolver {
        @NotNull
        public URL resolvePath(@NotNull String var1, @Nullable URL var2) throws MalformedURLException;
    }
}

