/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class TimeoutUtil {
    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long getDurationMillis(long startNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanoTime);
    }

    @ApiStatus.Experimental
    public static <E extends Throwable> long measureExecutionTime(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            TimeoutUtil.$$$reportNull$$$0(0);
        }
        long startTime = System.nanoTime();
        runnable.run();
        return TimeoutUtil.getDurationMillis(startTime);
    }

    @ApiStatus.Experimental
    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> runnable, @NotNull LongConsumer consumer2) throws E {
        if (runnable == null) {
            TimeoutUtil.$$$reportNull$$$0(1);
        }
        if (consumer2 == null) {
            TimeoutUtil.$$$reportNull$$$0(2);
        }
        TimeoutUtil.run(runnable, Long.MIN_VALUE, consumer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> runnable, long threshold, @NotNull LongConsumer longConsumer) throws E {
        if (runnable == null) {
            TimeoutUtil.$$$reportNull$$$0(3);
        }
        if (longConsumer == null) {
            TimeoutUtil.$$$reportNull$$$0(4);
        }
        long startNanoTime = System.nanoTime();
        try {
            runnable.run();
        }
        finally {
            long duration = TimeoutUtil.getDurationMillis(startNanoTime);
            if (duration >= threshold) {
                void consumer2;
                consumer2.accept(duration);
            }
        }
    }

    @ApiStatus.Experimental
    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> computable, @NotNull LongConsumer consumer2) throws E {
        if (computable == null) {
            TimeoutUtil.$$$reportNull$$$0(5);
        }
        if (consumer2 == null) {
            TimeoutUtil.$$$reportNull$$$0(6);
        }
        return TimeoutUtil.compute(computable, Long.MIN_VALUE, consumer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> computable, long threshold, @NotNull LongConsumer longConsumer) throws E {
        if (computable == null) {
            TimeoutUtil.$$$reportNull$$$0(7);
        }
        if (longConsumer == null) {
            TimeoutUtil.$$$reportNull$$$0(8);
        }
        long startNanoTime = System.nanoTime();
        try {
            T t = computable.compute();
            return t;
        }
        finally {
            long duration = TimeoutUtil.getDurationMillis(startNanoTime);
            if (duration >= threshold) {
                void consumer2;
                consumer2.accept(duration);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/TimeoutUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "measureExecutionTime";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "compute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

