/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.VersionedStorageChangeInternal;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012 \u0010\u0005\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ,\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\t0\b\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0007H\u0016J\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR(\u0010\u0005\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/workspace/storage/impl/VersionedStorageChangeImpl;", "Lcom/intellij/platform/workspace/storage/impl/VersionedStorageChangeInternal;", "storageBefore", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "storageAfter", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/platform/workspace/storage/EntityChange;", "<init>", "(Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;Ljava/util/Map;)V", "getStorageBefore", "()Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "getStorageAfter", "getChanges", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityClass", "getAllChanges", "Lkotlin/sequences/Sequence;", "intellij.platform.workspace.storage"})
final class VersionedStorageChangeImpl
implements VersionedStorageChangeInternal {
    @NotNull
    private final ImmutableEntityStorage storageBefore;
    @NotNull
    private final ImmutableEntityStorage storageAfter;
    @NotNull
    private final Map<Class<?>, List<EntityChange<?>>> changes;

    public VersionedStorageChangeImpl(@NotNull ImmutableEntityStorage storageBefore, @NotNull ImmutableEntityStorage storageAfter, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
        Intrinsics.checkNotNullParameter((Object)storageBefore, (String)"storageBefore");
        Intrinsics.checkNotNullParameter((Object)storageAfter, (String)"storageAfter");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.storageBefore = storageBefore;
        this.storageAfter = storageAfter;
        this.changes = changes;
    }

    @Override
    @NotNull
    public ImmutableEntityStorage getStorageBefore() {
        return this.storageBefore;
    }

    @Override
    @NotNull
    public ImmutableEntityStorage getStorageAfter() {
        return this.storageAfter;
    }

    @Override
    @NotNull
    public <T extends WorkspaceEntity> List<EntityChange<T>> getChanges(@NotNull Class<T> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        List list = this.changes.get(entityClass);
        List list2 = list instanceof List ? list : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public Sequence<EntityChange<?>> getAllChanges() {
        return SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.changes.values()));
    }
}

