/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.workspace.storage.ConnectionId;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.ExternalEntityMapping;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.AbstractRefsTable;
import com.intellij.platform.workspace.storage.impl.ChildEntityId;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.ConsistencyCheckerKt;
import com.intellij.platform.workspace.storage.impl.ConsistencyCheckingDisabler;
import com.intellij.platform.workspace.storage.impl.ConsistencyCheckingMode;
import com.intellij.platform.workspace.storage.impl.EntitiesBarrel;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.EntityPointerImpl;
import com.intellij.platform.workspace.storage.impl.ParentEntityId;
import com.intellij.platform.workspace.storage.impl.RefsTableKt;
import com.intellij.platform.workspace.storage.impl.StorageIndexes;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.external.EmptyExternalEntityMapping;
import com.intellij.platform.workspace.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.platform.workspace.storage.instrumentation.EntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlIndex;
import com.intellij.util.ConcurrencyUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 c2\u00020\u0001:\u0002bcB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010&\u001a\b\u0012\u0004\u0012\u0002H(0'\"\b\b\u0000\u0010(*\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H(0+H\u0016J \u0010,\u001a\u00020-\"\b\b\u0000\u0010(*\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H(0+H\u0016J\b\u0010.\u001a\u00020\u0011H\u0016J#\u0010/\u001a\f\u0012\u0006\b\u0001\u0012\u00020)\u0018\u0001002\n\u00101\u001a\u000602j\u0002`3H\u0000\u00a2\u0006\u0002\b4J!\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\n\u00101\u001a\u000602j\u0002`3H\u0000\u00a2\u0006\u0002\b6J>\u00107\u001a\b\u0012\u0004\u0012\u0002H80'\"\b\b\u0000\u0010(*\u000209\"\b\b\u0001\u00108*\u00020)2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H(0:2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H80+H\u0016J'\u0010;\u001a\u0004\u0018\u0001H(\"\b\b\u0000\u0010(*\u0002092\f\u00101\u001a\b\u0012\u0004\u0012\u0002H(0:H\u0016\u00a2\u0006\u0002\u0010<J!\u0010=\u001a\u00020\u0011\"\b\b\u0000\u0010(*\u0002092\f\u00101\u001a\b\u0012\u0004\u0012\u0002H(0:H\u0096\u0002J\"\u0010>\u001a\b\u0012\u0004\u0012\u00020)0'2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020\u00110@H\u0016J\"\u0010B\u001a\b\u0012\u0004\u0012\u0002HD0C\"\u0004\b\u0000\u0010D2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002HD0FH\u0016J\b\u0010G\u001a\u00020HH\u0016J1\u0010I\u001a\u0002HD\"\b\b\u0000\u0010D*\u00020)2\n\u0010J\u001a\u000602j\u0002`32\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HD0LH\u0016\u00a2\u0006\u0002\u0010MJ\u0015\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020 H\u0000\u00a2\u0006\u0002\bQJ'\u0010R\u001a\u0004\u0018\u0001HD\"\b\b\u0000\u0010D*\u00020)2\f\u0010S\u001a\b\u0012\u0004\u0012\u0002HD0TH\u0016\u00a2\u0006\u0002\u0010UJ\u001a\u0010V\u001a\u0004\u0018\u00010)2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020)H\u0016J\"\u0010Z\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\u0006\u0010W\u001a\u00020X2\n\u0010[\u001a\u000602j\u0002`3H\u0004J\u001e\u0010\\\u001a\b\u0012\u0004\u0012\u00020)0'2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020)H\u0016J&\u0010]\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003000'2\u0006\u0010W\u001a\u00020X2\n\u0010[\u001a\u000602j\u0002`3H\u0004J\u001a\u0010^\u001a\u0004\u0018\u00010)2\u0006\u0010W\u001a\u00020X2\u0006\u0010_\u001a\u00020)H\u0016J\"\u0010`\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\u0006\u0010W\u001a\u00020X2\n\u0010a\u001a\u000602j\u0002`3H\u0004R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002de\u00a8\u0006f"}, d2={"Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "Lcom/intellij/platform/workspace/storage/instrumentation/EntityStorageInstrumentation;", "<init>", "()V", "entitiesByType", "Lcom/intellij/platform/workspace/storage/impl/EntitiesBarrel;", "getEntitiesByType$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/EntitiesBarrel;", "refs", "Lcom/intellij/platform/workspace/storage/impl/AbstractRefsTable;", "getRefs$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/AbstractRefsTable;", "indexes", "Lcom/intellij/platform/workspace/storage/impl/StorageIndexes;", "getIndexes$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/StorageIndexes;", "brokenConsistency", "", "getBrokenConsistency$intellij_platform_workspace_storage", "()Z", "setBrokenConsistency$intellij_platform_workspace_storage", "(Z)V", "isEventHandling", "isEventHandling$intellij_platform_workspace_storage", "setEventHandling$intellij_platform_workspace_storage", "reporterExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "Lorg/jetbrains/annotations/NotNull;", "storageIsAlreadyApplied", "getStorageIsAlreadyApplied$intellij_platform_workspace_storage", "setStorageIsAlreadyApplied$intellij_platform_workspace_storage", "applyInfo", "", "getApplyInfo$intellij_platform_workspace_storage", "()Ljava/lang/String;", "setApplyInfo$intellij_platform_workspace_storage", "(Ljava/lang/String;)V", "detectBridgesUsageInListeners", "entities", "Lkotlin/sequences/Sequence;", "E", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityClass", "Ljava/lang/Class;", "entityCount", "", "isEmpty", "entityDataById", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;", "id", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "entityDataById$intellij_platform_workspace_storage", "entityDataByIdOrDie", "entityDataByIdOrDie$intellij_platform_workspace_storage", "referrers", "R", "Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "resolve", "(Lcom/intellij/platform/workspace/storage/SymbolicEntityId;)Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "contains", "entitiesBySource", "sourceFilter", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "getExternalMapping", "Lcom/intellij/platform/workspace/storage/ExternalEntityMapping;", "T", "identifier", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "getVirtualFileUrlIndex", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlIndex;", "initializeEntity", "entityId", "newInstance", "Lkotlin/Function0;", "(JLkotlin/jvm/functions/Function0;)Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "assertConsistencyInStrictMode", "", "message", "assertConsistencyInStrictMode$intellij_platform_workspace_storage", "resolveReference", "reference", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "(Lcom/intellij/platform/workspace/storage/EntityPointer;)Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "getOneChild", "connectionId", "Lcom/intellij/platform/workspace/storage/ConnectionId;", "parent", "getOneChildData", "parentEntityId", "getManyChildren", "getManyChildrenData", "getParent", "child", "getParentData", "childEntityId", "BridgeAccessThreadAnalyzer", "Companion", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntityStorageImpl;", "Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nImmutableEntityStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmutableEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/AbstractEntityStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1161:1\n1#2:1162\n14#3:1163\n*S KotlinDebug\n*F\n+ 1 ImmutableEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/AbstractEntityStorage\n*L\n1153#1:1163\n*E\n"})
public abstract class AbstractEntityStorage
implements EntityStorageInstrumentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean brokenConsistency;
    private boolean isEventHandling;
    @NotNull
    private final ThreadPoolExecutor reporterExecutor;
    private boolean storageIsAlreadyApplied;
    @Nullable
    private String applyInfo;
    private final boolean detectBridgesUsageInListeners;
    @NotNull
    private static final Logger LOG;

    private AbstractEntityStorage() {
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor("Workspace Model Reporter Pool");
        Intrinsics.checkNotNullExpressionValue((Object)threadPoolExecutor, (String)"newSingleThreadExecutor(...)");
        this.reporterExecutor = threadPoolExecutor;
        this.detectBridgesUsageInListeners = Registry.Companion.is("ide.workspace.model.assertions.bridges.usage", false);
    }

    @NotNull
    public abstract EntitiesBarrel getEntitiesByType$intellij_platform_workspace_storage();

    @NotNull
    public abstract AbstractRefsTable getRefs$intellij_platform_workspace_storage();

    @NotNull
    public abstract StorageIndexes getIndexes$intellij_platform_workspace_storage();

    public final boolean getBrokenConsistency$intellij_platform_workspace_storage() {
        return this.brokenConsistency;
    }

    public final void setBrokenConsistency$intellij_platform_workspace_storage(boolean bl) {
        this.brokenConsistency = bl;
    }

    public final boolean isEventHandling$intellij_platform_workspace_storage() {
        return this.isEventHandling;
    }

    public final void setEventHandling$intellij_platform_workspace_storage(boolean bl) {
        this.isEventHandling = bl;
    }

    public final boolean getStorageIsAlreadyApplied$intellij_platform_workspace_storage() {
        return this.storageIsAlreadyApplied;
    }

    public final void setStorageIsAlreadyApplied$intellij_platform_workspace_storage(boolean bl) {
        this.storageIsAlreadyApplied = bl;
    }

    @Nullable
    public final String getApplyInfo$intellij_platform_workspace_storage() {
        return this.applyInfo;
    }

    public final void setApplyInfo$intellij_platform_workspace_storage(@Nullable String string) {
        this.applyInfo = string;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> Sequence<E> entities(@NotNull Class<E> entityClass) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspace_storage().get(ClassToIntConverterKt.toClassId(entityClass));
        Sequence sequence2 = sequence = entityFamily != null && (entityFamily = entityFamily.all()) != null ? SequencesKt.map(entityFamily, arg_0 -> AbstractEntityStorage.entities$lambda$0(this, arg_0)) : null;
        Object object = sequence instanceof Sequence ? sequence : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        return object;
    }

    @Override
    public <E extends WorkspaceEntity> int entityCount(@NotNull Class<E> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspace_storage().get(ClassToIntConverterKt.toClassId(entityClass));
        return entityFamily != null ? entityFamily.size() : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getEntitiesByType$intellij_platform_workspace_storage().size() == 0;
    }

    @Nullable
    public final WorkspaceEntityData<? extends WorkspaceEntity> entityDataById$intellij_platform_workspace_storage(long id) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspace_storage().get(EntityIdKt.getClazz(id));
        return entityFamily != null ? entityFamily.get(EntityIdKt.getArrayId(id)) : null;
    }

    @NotNull
    public final WorkspaceEntityData<? extends WorkspaceEntity> entityDataByIdOrDie$intellij_platform_workspace_storage(long id) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspace_storage().get(EntityIdKt.getClazz(id));
        if (entityFamily == null) {
            throw new IllegalStateException(("Entity family doesn't exist or has no entities: " + ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(id))).toString());
        }
        EntityFamily<? extends WorkspaceEntity> entityFamily2 = entityFamily;
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = entityFamily2.getOrFail(EntityIdKt.getArrayId(id));
        if (workspaceEntityData == null) {
            throw new IllegalStateException(("Cannot find an entity by id " + EntityIdKt.asString(id)).toString());
        }
        return workspaceEntityData;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntityWithSymbolicId, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull SymbolicEntityId<? extends E> id, @NotNull Class<R> entityClass) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        int classId = ClassToIntConverterKt.toClassId(entityClass);
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getIndexes$intellij_platform_workspace_storage().getSoftLinks$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(id)), arg_0 -> AbstractEntityStorage.referrers$lambda$1(classId, arg_0)), arg_0 -> AbstractEntityStorage.referrers$lambda$2(this, arg_0));
    }

    @Override
    @Nullable
    public <E extends WorkspaceEntityWithSymbolicId> E resolve(@NotNull SymbolicEntityId<? extends E> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Long l = this.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(id);
        if (l == null) {
            return null;
        }
        long entityIds = l;
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspace_storage(entityIds);
        return (E)((WorkspaceEntityWithSymbolicId)(workspaceEntityData != null ? workspaceEntityData.createEntity(this) : null));
    }

    @Override
    public <E extends WorkspaceEntityWithSymbolicId> boolean contains(@NotNull SymbolicEntityId<? extends E> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return this.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(id) != null;
    }

    @Override
    @NotNull
    public Sequence<WorkspaceEntity> entitiesBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter) {
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        EntityStorageInternalIndex<EntitySource> index = this.getIndexes$intellij_platform_workspace_storage().getEntitySourceIndex$intellij_platform_workspace_storage();
        return SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)index.entries$intellij_platform_workspace_storage()), sourceFilter), arg_0 -> AbstractEntityStorage.entitiesBySource$lambda$4(index, this, arg_0));
    }

    @Override
    @NotNull
    public <T> ExternalEntityMapping<T> getExternalMapping(@NotNull ExternalMappingKey<T> identifier) {
        ExternalEntityMappingImpl<?> externalEntityMappingImpl;
        ExternalEntityMappingImpl<?> index;
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        if (this.detectBridgesUsageInListeners && this.isEventHandling) {
            this.reporterExecutor.execute(new BridgeAccessThreadAnalyzer(new Exception(), identifier));
        }
        ExternalEntityMappingImpl<?> externalEntityMappingImpl2 = index = (externalEntityMappingImpl = this.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage().get(identifier)) instanceof ExternalEntityMappingImpl ? externalEntityMappingImpl : null;
        if (index == null) {
            EmptyExternalEntityMapping emptyExternalEntityMapping = EmptyExternalEntityMapping.INSTANCE;
            Intrinsics.checkNotNull((Object)emptyExternalEntityMapping, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.ExternalEntityMapping<T of com.intellij.platform.workspace.storage.impl.AbstractEntityStorage.getExternalMapping>");
            return emptyExternalEntityMapping;
        }
        index.setTypedEntityStorage$intellij_platform_workspace_storage(this);
        return index;
    }

    @Override
    @NotNull
    public VirtualFileUrlIndex getVirtualFileUrlIndex() {
        this.getIndexes$intellij_platform_workspace_storage().getVirtualFileIndex$intellij_platform_workspace_storage().setTypedEntityStorage$intellij_platform_workspace_storage(this);
        return this.getIndexes$intellij_platform_workspace_storage().getVirtualFileIndex$intellij_platform_workspace_storage();
    }

    @Override
    @NotNull
    public <T extends WorkspaceEntity> T initializeEntity(long entityId, @NotNull Function0<? extends T> newInstance) {
        Intrinsics.checkNotNullParameter(newInstance, (String)"newInstance");
        return (T)((WorkspaceEntity)newInstance.invoke());
    }

    public final void assertConsistencyInStrictMode$intellij_platform_workspace_storage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (ConsistencyCheckingMode.Companion.getCurrent$intellij_platform_workspace_storage() != ConsistencyCheckingMode.DISABLED && !ConsistencyCheckingDisabler.INSTANCE.isDisabled$intellij_platform_workspace_storage()) {
            try {
                ConsistencyCheckerKt.assertConsistency(this);
            }
            catch (Throwable e) {
                this.brokenConsistency = true;
                LOG.error(message, e);
            }
        }
    }

    @Override
    @Nullable
    public <T extends WorkspaceEntity> T resolveReference(@NotNull EntityPointer<? extends T> reference) {
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
        EntityPointerImpl cfr_ignored_0 = (EntityPointerImpl)reference;
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspace_storage(((EntityPointerImpl)reference).getId$intellij_platform_workspace_storage());
        WorkspaceEntity workspaceEntity = workspaceEntityData != null ? workspaceEntityData.createEntity(this) : null;
        return (T)(workspaceEntity instanceof WorkspaceEntity ? workspaceEntity : null);
    }

    @Override
    @Nullable
    public WorkspaceEntity getOneChild(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity parent) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        WorkspaceEntityData<?> workspaceEntityData = this.getOneChildData(connectionId, UtilsKt.asBase(parent).getId());
        return workspaceEntityData != null ? (WorkspaceEntity)workspaceEntityData.createEntity(this) : null;
    }

    @Nullable
    protected final WorkspaceEntityData<?> getOneChildData(@NotNull ConnectionId connectionId, long parentEntityId) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        switch (WhenMappings.$EnumSwitchMapping$0[connectionId.getConnectionType().ordinal()]) {
            case 1: {
                return this.getRefs$intellij_platform_workspace_storage().getOneToOneChild(connectionId, EntityIdKt.getArrayId(parentEntityId), arg_0 -> AbstractEntityStorage.getOneChildData$lambda$5(this, connectionId, arg_0));
            }
            case 2: {
                ChildEntityId childEntityId = (ChildEntityId)CollectionsKt.singleOrNull(this.getRefs$intellij_platform_workspace_storage().getChildrenByParent-ePHS_xw(connectionId, RefsTableKt.asParent(parentEntityId)));
                if (childEntityId == null) {
                    return null;
                }
                long childId = childEntityId.unbox-impl();
                return this.entityDataByIdOrDie$intellij_platform_workspace_storage(childId);
            }
            case 3: 
            case 4: {
                throw new IllegalStateException("This function works only with one-to-one connections".toString());
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @NotNull
    public Sequence<WorkspaceEntity> getManyChildren(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity parent) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return SequencesKt.map(this.getManyChildrenData(connectionId, UtilsKt.asBase(parent).getId()), arg_0 -> AbstractEntityStorage.getManyChildren$lambda$6(this, arg_0));
    }

    @NotNull
    protected final Sequence<WorkspaceEntityData<?>> getManyChildrenData(@NotNull ConnectionId connectionId, long parentEntityId) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        switch (WhenMappings.$EnumSwitchMapping$0[connectionId.getConnectionType().ordinal()]) {
            case 4: {
                return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getRefs$intellij_platform_workspace_storage().getChildrenByParent-ePHS_xw(connectionId, RefsTableKt.asParent(parentEntityId))), arg_0 -> AbstractEntityStorage.getManyChildrenData$lambda$7(this, arg_0));
            }
            case 3: {
                return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getRefs$intellij_platform_workspace_storage().getChildrenByParent-ePHS_xw(connectionId, RefsTableKt.asParent(parentEntityId))), arg_0 -> AbstractEntityStorage.getManyChildrenData$lambda$8(this, arg_0));
            }
            case 1: 
            case 2: {
                throw new IllegalStateException("This function works only with one-to-many connections".toString());
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @Nullable
    public WorkspaceEntity getParent(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity child) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        WorkspaceEntityData<?> workspaceEntityData = this.getParentData(connectionId, UtilsKt.asBase(child).getId());
        return workspaceEntityData != null ? (WorkspaceEntity)workspaceEntityData.createEntity(this) : null;
    }

    @Nullable
    protected final WorkspaceEntityData<?> getParentData(@NotNull ConnectionId connectionId, long childEntityId) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        switch (WhenMappings.$EnumSwitchMapping$0[connectionId.getConnectionType().ordinal()]) {
            case 1: {
                return this.getRefs$intellij_platform_workspace_storage().getOneToOneParent(connectionId, EntityIdKt.getArrayId(childEntityId), arg_0 -> AbstractEntityStorage.getParentData$lambda$9(connectionId, this, arg_0));
            }
            case 4: {
                return this.getRefs$intellij_platform_workspace_storage().getOneToManyParent(connectionId, EntityIdKt.getArrayId(childEntityId), arg_0 -> AbstractEntityStorage.getParentData$lambda$10(connectionId, this, arg_0));
            }
            case 3: {
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData;
                ParentEntityId parentEntityId = this.getRefs$intellij_platform_workspace_storage().getOneToAbstractManyParent-jelK74M(connectionId, RefsTableKt.asChild(childEntityId));
                if (parentEntityId != null) {
                    long it = parentEntityId.unbox-impl();
                    boolean bl = false;
                    workspaceEntityData = this.entityDataByIdOrDie$intellij_platform_workspace_storage(it);
                } else {
                    workspaceEntityData = null;
                }
                return workspaceEntityData;
            }
            case 2: {
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData;
                ParentEntityId parentEntityId = this.getRefs$intellij_platform_workspace_storage().getOneToAbstractOneParent-jelK74M(connectionId, RefsTableKt.asChild(childEntityId));
                if (parentEntityId != null) {
                    long it = parentEntityId.unbox-impl();
                    boolean bl = false;
                    workspaceEntityData = this.entityDataByIdOrDie$intellij_platform_workspace_storage(it);
                } else {
                    workspaceEntityData = null;
                }
                return workspaceEntityData;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final WorkspaceEntity entities$lambda$0(AbstractEntityStorage this$0, WorkspaceEntityData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createEntity(this$0);
    }

    private static final boolean referrers$lambda$1(int $classId, long it) {
        return EntityIdKt.getClazz(it) == $classId;
    }

    private static final WorkspaceEntity referrers$lambda$2(AbstractEntityStorage this$0, long it) {
        WorkspaceEntity workspaceEntity = this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(it).createEntity(this$0);
        Intrinsics.checkNotNull((Object)workspaceEntity, (String)"null cannot be cast to non-null type R of com.intellij.platform.workspace.storage.impl.AbstractEntityStorage.referrers");
        return workspaceEntity;
    }

    private static final WorkspaceEntity entitiesBySource$lambda$4$lambda$3(AbstractEntityStorage this$0, long it) {
        return this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(it).createEntity(this$0);
    }

    private static final Sequence entitiesBySource$lambda$4(EntityStorageInternalIndex $index, AbstractEntityStorage this$0, EntitySource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        List<Long> list = $index.getIdsByEntry$intellij_platform_workspace_storage(source);
        if (list == null) {
            throw new IllegalStateException(("Entity source " + source + " expected to be in the index").toString());
        }
        List<Long> entityIds = list;
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)entityIds), arg_0 -> AbstractEntityStorage.entitiesBySource$lambda$4$lambda$3(this$0, arg_0));
    }

    private static final WorkspaceEntityData getOneChildData$lambda$5(AbstractEntityStorage this$0, ConnectionId $connectionId, int it) {
        return this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(EntityIdKt.createEntityId(it, $connectionId.getChildClass()));
    }

    private static final WorkspaceEntity getManyChildren$lambda$6(AbstractEntityStorage this$0, WorkspaceEntityData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createEntity(this$0);
    }

    private static final WorkspaceEntityData getManyChildrenData$lambda$7(AbstractEntityStorage this$0, ChildEntityId it) {
        return this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(it.unbox-impl());
    }

    private static final WorkspaceEntityData getManyChildrenData$lambda$8(AbstractEntityStorage this$0, ChildEntityId it) {
        return this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(it.unbox-impl());
    }

    private static final WorkspaceEntityData getParentData$lambda$9(ConnectionId $connectionId, AbstractEntityStorage this$0, int it) {
        long entityId = EntityIdKt.createEntityId(it, $connectionId.getParentClass());
        return this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(entityId);
    }

    private static final WorkspaceEntityData getParentData$lambda$10(ConnectionId $connectionId, AbstractEntityStorage this$0, int it) {
        long entityId = EntityIdKt.createEntityId(it, $connectionId.getParentClass());
        return this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(entityId);
    }

    public /* synthetic */ AbstractEntityStorage(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractEntityStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB!\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage$BridgeAccessThreadAnalyzer;", "Ljava/lang/Runnable;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "identifier", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "", "<init>", "(Ljava/lang/Exception;Lcom/intellij/platform/workspace/storage/ExternalMappingKey;)V", "run", "", "Companion", "intellij.platform.workspace.storage"})
    @SourceDebugExtension(value={"SMAP\nImmutableEntityStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmutableEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/AbstractEntityStorage$BridgeAccessThreadAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1161:1\n1755#2,3:1162\n*S KotlinDebug\n*F\n+ 1 ImmutableEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/AbstractEntityStorage$BridgeAccessThreadAnalyzer\n*L\n1130#1:1162,3\n*E\n"})
    private static final class BridgeAccessThreadAnalyzer
    implements Runnable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Exception exception;
        @NotNull
        private final ExternalMappingKey<Object> identifier;
        @NotNull
        private static final List<String> predefinedBridges;

        public BridgeAccessThreadAnalyzer(@NotNull Exception exception, @NotNull ExternalMappingKey<Object> identifier) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
            this.exception = exception;
            this.identifier = identifier;
        }

        @Override
        public void run() {
            boolean bl;
            block5: {
                Iterable $this$any$iv = predefinedBridges;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)this.identifier.toString(), (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                return;
            }
            Object[] stackTrace = this.exception.getStackTrace();
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])stackTrace);
            while (iterator2.hasNext()) {
                String elementAsString;
                StackTraceElement stackTraceElement = (StackTraceElement)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement.toString(), (String)"toString(...)");
                if (!StringsKt.contains$default((CharSequence)elementAsString, (CharSequence)"GlobalWorkspaceModel.onChanged", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)elementAsString, (CharSequence)"GlobalWorkspaceModel.onBeforeChanged", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)elementAsString, (CharSequence)"WorkspaceFileIndexDataImpl.onEntitiesChanged", (boolean)false, (int)2, null)) continue;
                return;
            }
            Companion.getLOG().error("Access to the bridge is prohibited during the event handling ", this.exception);
        }

        static {
            Object[] objectArray = new String[]{"intellij.modules.bridge", "intellij.artifacts.bridge", "intellij.facets.bridge", "intellij.libraries.bridge"};
            predefinedBridges = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage$BridgeAccessThreadAnalyzer$Companion;", "", "<init>", "()V", "predefinedBridges", "", "", "intellij.platform.workspace.storage"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionId.ConnectionType.values().length];
            try {
                nArray[ConnectionId.ConnectionType.ONE_TO_ONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionId.ConnectionType.ONE_TO_MANY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

