/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.RestrictedEnvironmentBlockedCallDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.model.LintModelModuleType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0002:;B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u001f*\u00020$2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u001f*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J(\u0010&\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0012H\u0002J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.2\u0006\u0010+\u001a\u00020\u0012H\u0002J\u0010\u0010/\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u000200H\u0016J \u00102\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u0002002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00142\u0006\u00108\u001a\u000209H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f*\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006<"}, d2={"Lcom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "relevantExprs", "", "Lorg/jetbrains/uast/UElement;", "", "Lcom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector$RelevantExpr;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "applicableAnnotations", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "element", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "restrictedEnvironments", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/uast/UAnnotation;", "getRestrictedEnvironments", "(Lorg/jetbrains/uast/UAnnotation;)Lkotlin/sequences/Sequence;", "outerAnnotations", "Lcom/intellij/psi/PsiElement;", "outermostMethodOrBlock", "visitBlockedCall", "callExpression", "Lorg/jetbrains/uast/UCallExpression;", "blockedSinceTargetSdk", "", "environment", "visitCheckExpression", "expression", "Lorg/jetbrains/uast/UExpression;", "beforeCheckFile", "Lcom/android/tools/lint/detector/api/Context;", "afterCheckFile", "filterIncident", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "isPrivacySandboxSdkProject", "project", "Lcom/android/tools/lint/detector/api/Project;", "RelevantExpr", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nRestrictedEnvironmentBlockedCallDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestrictedEnvironmentBlockedCallDetector.kt\ncom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,414:1\n381#2,7:415\n381#2,7:422\n*S KotlinDebug\n*F\n+ 1 RestrictedEnvironmentBlockedCallDetector.kt\ncom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector\n*L\n257#1:415,7\n264#1:422,7\n*E\n"})
public final class RestrictedEnvironmentBlockedCallDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UElement, List<RelevantExpr>> relevantExprs = new LinkedHashMap();
    @NotNull
    private static final String ANNOTATION_ATTR_FROM = "from";
    @NotNull
    private static final String ANNOTATION_ATTR_ENVS = "environments";
    @NotNull
    private static final String RESTRICTED_ANNOTATION_FQN = "androidx.annotation.RestrictedForEnvironment";
    @NotNull
    private static final String CHECKS_SANDBOX_ANNOTATION_FQN = "androidx.annotation.ChecksRestrictedEnvironment";
    @NotNull
    private static final String SDK_SANDBOX_ENVIRONMENT_NAME = "SDK_SANDBOX";
    @NotNull
    private static final String LINT_MAP_ENVIRONMENT_KEY = "env";
    @NotNull
    private static final String LINT_MAP_TARGET_SDK_KEY = "sdk";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RestrictedEnvironmentBlockedCallDetector.class, EnumSet.of((Enum)Scope.ALL_JAVA_FILES));
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final HashMap<String, Integer> BLOCKED_CLASSES_FROM;

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context, this){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ RestrictedEnvironmentBlockedCallDetector this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
            }

            public void visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null) {
                    return;
                }
                PsiMethod method = psiMethod;
                if (Intrinsics.areEqual((Object)method.getName(), (Object)"isSdkSandbox") && this.$context.getEvaluator().methodMatches(method, "android.os.Process", false, new String[0])) {
                    boolean bl;
                    PsiElement $this$toUElementOfType$iv = (PsiElement)method;
                    boolean $i$f$toUElementOfType = false;
                    Object object = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                    if (object != null && (object = object.getUAnnotations()) != null) {
                        boolean bl2;
                        block12: {
                            Iterable $this$any$iv = (Iterable)object;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    UAnnotation it = (UAnnotation)element$iv;
                                    boolean bl3 = false;
                                    if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"androidx.annotation.ChecksRestrictedEnvironment")) continue;
                                    bl2 = true;
                                    break block12;
                                }
                                bl2 = false;
                            }
                        }
                        bl = bl2;
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        return;
                    }
                    RestrictedEnvironmentBlockedCallDetector.access$visitCheckExpression(this.this$0, (UExpression)node, "SDK_SANDBOX");
                    return;
                }
                Object object = method.getContainingClass();
                if (object == null || (object = object.getQualifiedName()) == null) {
                    return;
                }
                Object containingClassFqn = object;
                Integer blockedFrom = (Integer)RestrictedEnvironmentBlockedCallDetector.access$getBLOCKED_CLASSES_FROM$cp().get(containingClassFqn);
                if (blockedFrom != null) {
                    boolean bl;
                    block13: {
                        Sequence $this$any$iv = RestrictedEnvironmentBlockedCallDetector.access$outerAnnotations(this.this$0, (PsiElement)method, this.$context);
                        boolean $i$f$any = false;
                        for (E element$iv : $this$any$iv) {
                            UAnnotation it = (UAnnotation)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"androidx.annotation.RestrictedForEnvironment")) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                    if (bl) {
                        return;
                    }
                    RestrictedEnvironmentBlockedCallDetector.access$visitBlockedCall(this.this$0, this.$context, node, blockedFrom, "SDK_SANDBOX");
                    return;
                }
            }
        };
    }

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{RESTRICTED_ANNOTATION_FQN, CHECKS_SANDBOX_ANNOTATION_FQN};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        String string = annotationInfo.getQualifiedName();
        if (Intrinsics.areEqual((Object)string, (Object)RESTRICTED_ANNOTATION_FQN)) {
            if (WhenMappings.$EnumSwitchMapping$0[usageInfo.getType().ordinal()] == 1) {
                UCallExpression uCallExpression = element instanceof UCallExpression ? (UCallExpression)element : null;
                if (uCallExpression == null) {
                    return;
                }
                UCallExpression callExpression = uCallExpression;
                UExpression uExpression = annotationInfo.getAnnotation().findAttributeValue(ANNOTATION_ATTR_FROM);
                Object object = uExpression != null ? uExpression.evaluate() : null;
                Integer n = object instanceof Integer ? (Integer)object : null;
                if (n == null) {
                    return;
                }
                int from = n;
                for (String environment : this.getRestrictedEnvironments(annotationInfo.getAnnotation())) {
                    this.visitBlockedCall(context, callExpression, from, environment);
                }
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)CHECKS_SANDBOX_ANNOTATION_FQN)) {
            switch (WhenMappings.$EnumSwitchMapping$0[usageInfo.getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    UExpression uExpression = element instanceof UExpression ? (UExpression)element : null;
                    if (uExpression == null) {
                        return;
                    }
                    UExpression expression = uExpression;
                    for (String environment : this.getRestrictedEnvironments(annotationInfo.getAnnotation())) {
                        this.visitCheckExpression(expression, environment);
                    }
                    break;
                }
            }
        }
    }

    private final Sequence<String> getRestrictedEnvironments(UAnnotation $this$restrictedEnvironments) {
        UAnnotation annotation = $this$restrictedEnvironments;
        UExpression uExpression = annotation.findAttributeValue(ANNOTATION_ATTR_ENVS);
        UCallExpression uCallExpression = uExpression instanceof UCallExpression ? (UCallExpression)uExpression : null;
        if (uCallExpression == null) {
            return SequencesKt.emptySequence();
        }
        UCallExpression envArrayCall = uCallExpression;
        if (!envArrayCall.hasKind(UastCallKind.NESTED_ARRAY_INITIALIZER)) {
            return SequencesKt.emptySequence();
        }
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)envArrayCall.getValueArguments()), (Function1)restrictedEnvironments.1.INSTANCE);
    }

    private final Sequence<UAnnotation> outerAnnotations(PsiElement $this$outerAnnotations, JavaContext context) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super UAnnotation>, Continuation<? super Unit>, Object>($this$outerAnnotations, context, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PsiElement $this_outerAnnotations;
            final /* synthetic */ JavaContext $context;
            {
                this.$this_outerAnnotations = $receiver;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        cur = this.$this_outerAnnotations;
lbl7:
                        // 2 sources

                        while (cur != null) {
                            if (cur instanceof PsiModifierListOwner) {
                                this.L$0 = $this$sequence;
                                this.L$1 = cur;
                                this.label = 1;
                                v0 = $this$sequence.yieldAll((Iterable)JavaEvaluator.getAnnotations$default((JavaEvaluator)this.$context.getEvaluator(), (PsiModifierListOwner)((PsiModifierListOwner)cur), (boolean)true, null, (int)4, null), (Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                            }
                            ** GOTO lbl22
                        }
                        break;
                    }
                    case 1: {
                        cur = (PsiElement)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        cur = cur.getParent();
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super UAnnotation> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Sequence<UAnnotation> outerAnnotations(UElement $this$outerAnnotations, JavaContext context) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super UAnnotation>, Continuation<? super Unit>, Object>($this$outerAnnotations, context, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UElement $this_outerAnnotations;
            final /* synthetic */ JavaContext $context;
            {
                this.$this_outerAnnotations = $receiver;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        cur = this.$this_outerAnnotations;
lbl7:
                        // 2 sources

                        while (cur != null) {
                            if (cur instanceof UAnnotated) {
                                this.L$0 = $this$sequence;
                                this.L$1 = cur;
                                this.label = 1;
                                v0 = $this$sequence.yieldAll((Iterable)this.$context.getEvaluator().getAllAnnotations((UAnnotated)cur, true), (Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                            }
                            ** GOTO lbl22
                        }
                        break;
                    }
                    case 1: {
                        cur = (UElement)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        cur = cur.getUastParent();
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super UAnnotation> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final UElement outermostMethodOrBlock(UElement element) {
        UElement lastMethodOrBlock = null;
        for (UElement cur = element; cur != null; cur = cur.getUastParent()) {
            if (!(cur instanceof UMethod) && !(cur instanceof UBlockExpression) && !(cur instanceof UField)) continue;
            lastMethodOrBlock = cur;
        }
        return lastMethodOrBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final void visitBlockedCall(JavaContext context, UCallExpression callExpression, int blockedSinceTargetSdk, String environment) {
        Object object;
        void $this$getOrPut$iv;
        Object anno2;
        for (Object anno2 : this.outerAnnotations((UElement)callExpression, context)) {
            if (!Intrinsics.areEqual((Object)anno2.getQualifiedName(), (Object)RESTRICTED_ANNOTATION_FQN) || !SequencesKt.contains(this.getRestrictedEnvironments((UAnnotation)anno2), (Object)environment)) continue;
            UExpression uExpression = anno2.findAttributeValue(ANNOTATION_ATTR_FROM);
            Object object2 = uExpression != null ? uExpression.evaluate() : null;
            Integer n = object2 instanceof Integer ? (Integer)object2 : null;
            if (n == null) {
                return;
            }
            int blockedSinceOuter = n;
            if (blockedSinceOuter > blockedSinceTargetSdk) continue;
            return;
        }
        UElement uElement = this.outermostMethodOrBlock((UElement)callExpression);
        if (uElement == null) {
            return;
        }
        UElement outermost = uElement;
        anno2 = this.relevantExprs;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(outermost);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(outermost, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(new RelevantExpr.BlockedCall(callExpression, blockedSinceTargetSdk, environment));
    }

    /*
     * WARNING - void declaration
     */
    private final void visitCheckExpression(UExpression expression, String environment) {
        Object object;
        void $this$getOrPut$iv;
        UElement uElement = this.outermostMethodOrBlock((UElement)expression);
        if (uElement == null) {
            return;
        }
        UElement outermost = uElement;
        Map<UElement, List<RelevantExpr>> map = this.relevantExprs;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(outermost);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(outermost, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(new RelevantExpr.EnvironmentCheck(expression, environment));
    }

    public void beforeCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.relevantExprs.clear();
    }

    public void afterCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context instanceof JavaContext)) {
            return;
        }
        Iterator<Map.Entry<UElement, List<RelevantExpr>>> iterator = this.relevantExprs.entrySet().iterator();
        while (iterator.hasNext()) {
            List<RelevantExpr> exprs = iterator.next().getValue();
            HashSet<String> environmentChecksSeen = new HashSet<String>();
            for (RelevantExpr expr : exprs) {
                RelevantExpr relevantExpr = expr;
                if (relevantExpr instanceof RelevantExpr.EnvironmentCheck) {
                    environmentChecksSeen.add(((RelevantExpr.EnvironmentCheck)expr).getEnvironment());
                    continue;
                }
                if (relevantExpr instanceof RelevantExpr.BlockedCall) {
                    if (environmentChecksSeen.contains(((RelevantExpr.BlockedCall)expr).getEnvironment())) continue;
                    Object message2 = "Call is blocked in the Privacy Sandbox";
                    if (((RelevantExpr.BlockedCall)expr).getFrom() > 1) {
                        message2 = (String)message2 + " when `targetSdk` is " + ((RelevantExpr.BlockedCall)expr).getFrom() + " or above";
                    }
                    context.report(new Incident(ISSUE, ((JavaContext)context).getLocation((UElement)((RelevantExpr.BlockedCall)expr).getCallExpression()), (String)message2), new LintMap().put(LINT_MAP_ENVIRONMENT_KEY, ((RelevantExpr.BlockedCall)expr).getEnvironment()).put(LINT_MAP_TARGET_SDK_KEY, ((RelevantExpr.BlockedCall)expr).getFrom()));
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        this.relevantExprs.clear();
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (this.isPrivacySandboxSdkProject(context.getMainProject()) && Intrinsics.areEqual((Object)LintMap.getString$default((LintMap)map, (String)LINT_MAP_ENVIRONMENT_KEY, null, (int)2, null), (Object)SDK_SANDBOX_ENVIRONMENT_NAME)) {
            Integer n = LintMap.getInt$default((LintMap)map, (String)LINT_MAP_TARGET_SDK_KEY, null, (int)2, null);
            if (n == null) {
                return false;
            }
            int blockedSinceTargetSdk = n;
            if (context.getMainProject().getTargetSdk() >= blockedSinceTargetSdk) {
                return true;
            }
        }
        return false;
    }

    private final boolean isPrivacySandboxSdkProject(Project project) {
        return project.getType() == LintModelModuleType.PRIVACY_SANDBOX_SDK;
    }

    public static final /* synthetic */ void access$visitCheckExpression(RestrictedEnvironmentBlockedCallDetector $this, UExpression expression, String environment) {
        $this.visitCheckExpression(expression, environment);
    }

    public static final /* synthetic */ HashMap access$getBLOCKED_CLASSES_FROM$cp() {
        return BLOCKED_CLASSES_FROM;
    }

    public static final /* synthetic */ Sequence access$outerAnnotations(RestrictedEnvironmentBlockedCallDetector $this, PsiElement $receiver, JavaContext context) {
        return $this.outerAnnotations($receiver, context);
    }

    public static final /* synthetic */ void access$visitBlockedCall(RestrictedEnvironmentBlockedCallDetector $this, JavaContext context, UCallExpression callExpression, int blockedSinceTargetSdk, String environment) {
        $this.visitBlockedCall(context, callExpression, blockedSinceTargetSdk, environment);
    }

    static {
        Pair[] pairArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)pairArray, (String)"PrivacySandboxBlockedCall", (String)"Call is blocked in the Privacy Sandbox", (String)"\n          Many APIs are unavailable in the Privacy Sandbox, depending on the `targetSdk`.\n\n          If your code is designed to run in the sandbox (and never outside the sandbox) then you should remove the \\\n          blocked calls to avoid exceptions at runtime.\n\n          If your code is part of a library that can be executed both inside and outside the sandbox, \\\n          surround the code with `if (!Process.isSdkSandbox()) { ... }` (or use your own field or method annotated \\\n          with `@ChecksRestrictedEnvironment`) to avoid executing blocked calls when in the sandbox. Or, add the \\\n          `@RestrictedForEnvironment` annotation to the containing method if the entire method should not be called \\\n          when in the sandbox.\n\n          This check is disabled by default, and should only be enabled in modules that may execute in the \\\n          Privacy Sandbox.\n          ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3088, null);
        pairArray = new Pair[]{TuplesKt.to((Object)"android.hardware.biometrics.BiometricManager", (Object)34), TuplesKt.to((Object)"android.app.blob.BlobStoreManager", (Object)34), TuplesKt.to((Object)"android.os.BugReportManager", (Object)34), TuplesKt.to((Object)"android.content.pm.CrossProfileApps", (Object)34), TuplesKt.to((Object)"android.app.admin.DevicePolicyManager", (Object)34), TuplesKt.to((Object)"android.content.pm.verify.domain.DomainVerificationManager", (Object)34), TuplesKt.to((Object)"android.security.FileIntegrityManager", (Object)34), TuplesKt.to((Object)"android.hardware.fingerprint.FingerprintManager", (Object)34), TuplesKt.to((Object)"android.health.connect.HealthConnectManager", (Object)34), TuplesKt.to((Object)"android.app.people.PeopleManager", (Object)34), TuplesKt.to((Object)"android.app.sdksandbox.SdkSandboxManager", (Object)34), TuplesKt.to((Object)"android.content.pm.ShortcutManager", (Object)34), TuplesKt.to((Object)"android.app.slice.SliceManager", (Object)34), TuplesKt.to((Object)"android.companion.virtual.VirtualDeviceManager", (Object)34), TuplesKt.to((Object)"android.net.VpnManager", (Object)34), TuplesKt.to((Object)"android.net.wifi.WifiManager", (Object)34), TuplesKt.to((Object)"android.net.wifi.aware.WifiAwareManager", (Object)34), TuplesKt.to((Object)"android.net.wifi.p2p.WifiP2pManager", (Object)34), TuplesKt.to((Object)"android.location.CountryDetector", (Object)1), TuplesKt.to((Object)"android.app.tare.EconomyManager", (Object)1), TuplesKt.to((Object)"android.app.trust.TrustManager", (Object)1), TuplesKt.to((Object)"android.hardware.devicestate.DeviceStateManager", (Object)1)};
        BLOCKED_CLASSES_FROM = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector$Companion;", "", "<init>", "()V", "ANNOTATION_ATTR_FROM", "", "ANNOTATION_ATTR_ENVS", "RESTRICTED_ANNOTATION_FQN", "CHECKS_SANDBOX_ANNOTATION_FQN", "SDK_SANDBOX_ENVIRONMENT_NAME", "LINT_MAP_ENVIRONMENT_KEY", "LINT_MAP_TARGET_SDK_KEY", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "BLOCKED_CLASSES_FROM", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector$RelevantExpr;", "", "BlockedCall", "EnvironmentCheck", "Lcom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector$RelevantExpr$BlockedCall;", "Lcom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector$RelevantExpr$EnvironmentCheck;", "lint-checks"})
    private static interface RelevantExpr {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector$RelevantExpr$BlockedCall;", "Lcom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector$RelevantExpr;", "callExpression", "Lorg/jetbrains/uast/UCallExpression;", "from", "", "environment", "", "<init>", "(Lorg/jetbrains/uast/UCallExpression;ILjava/lang/String;)V", "getCallExpression", "()Lorg/jetbrains/uast/UCallExpression;", "getFrom", "()I", "getEnvironment", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "lint-checks"})
        public static final class BlockedCall
        implements RelevantExpr {
            @NotNull
            private final UCallExpression callExpression;
            private final int from;
            @NotNull
            private final String environment;

            public BlockedCall(@NotNull UCallExpression callExpression, int from, @NotNull String environment) {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                this.callExpression = callExpression;
                this.from = from;
                this.environment = environment;
            }

            @NotNull
            public final UCallExpression getCallExpression() {
                return this.callExpression;
            }

            public final int getFrom() {
                return this.from;
            }

            @NotNull
            public final String getEnvironment() {
                return this.environment;
            }

            @NotNull
            public final UCallExpression component1() {
                return this.callExpression;
            }

            public final int component2() {
                return this.from;
            }

            @NotNull
            public final String component3() {
                return this.environment;
            }

            @NotNull
            public final BlockedCall copy(@NotNull UCallExpression callExpression, int from, @NotNull String environment) {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                return new BlockedCall(callExpression, from, environment);
            }

            public static /* synthetic */ BlockedCall copy$default(BlockedCall blockedCall, UCallExpression uCallExpression, int n, String string, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    uCallExpression = blockedCall.callExpression;
                }
                if ((n2 & 2) != 0) {
                    n = blockedCall.from;
                }
                if ((n2 & 4) != 0) {
                    string = blockedCall.environment;
                }
                return blockedCall.copy(uCallExpression, n, string);
            }

            @NotNull
            public String toString() {
                return "BlockedCall(callExpression=" + this.callExpression + ", from=" + this.from + ", environment=" + this.environment + ")";
            }

            public int hashCode() {
                int result = this.callExpression.hashCode();
                result = result * 31 + Integer.hashCode(this.from);
                result = result * 31 + this.environment.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BlockedCall)) {
                    return false;
                }
                BlockedCall blockedCall = (BlockedCall)other;
                if (!Intrinsics.areEqual((Object)this.callExpression, (Object)blockedCall.callExpression)) {
                    return false;
                }
                if (this.from != blockedCall.from) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.environment, (Object)blockedCall.environment);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector$RelevantExpr$EnvironmentCheck;", "Lcom/android/tools/lint/checks/RestrictedEnvironmentBlockedCallDetector$RelevantExpr;", "expression", "Lorg/jetbrains/uast/UExpression;", "environment", "", "<init>", "(Lorg/jetbrains/uast/UExpression;Ljava/lang/String;)V", "getExpression", "()Lorg/jetbrains/uast/UExpression;", "getEnvironment", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "lint-checks"})
        public static final class EnvironmentCheck
        implements RelevantExpr {
            @NotNull
            private final UExpression expression;
            @NotNull
            private final String environment;

            public EnvironmentCheck(@NotNull UExpression expression, @NotNull String environment) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                this.expression = expression;
                this.environment = environment;
            }

            @NotNull
            public final UExpression getExpression() {
                return this.expression;
            }

            @NotNull
            public final String getEnvironment() {
                return this.environment;
            }

            @NotNull
            public final UExpression component1() {
                return this.expression;
            }

            @NotNull
            public final String component2() {
                return this.environment;
            }

            @NotNull
            public final EnvironmentCheck copy(@NotNull UExpression expression, @NotNull String environment) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                return new EnvironmentCheck(expression, environment);
            }

            public static /* synthetic */ EnvironmentCheck copy$default(EnvironmentCheck environmentCheck, UExpression uExpression, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    uExpression = environmentCheck.expression;
                }
                if ((n & 2) != 0) {
                    string = environmentCheck.environment;
                }
                return environmentCheck.copy(uExpression, string);
            }

            @NotNull
            public String toString() {
                return "EnvironmentCheck(expression=" + this.expression + ", environment=" + this.environment + ")";
            }

            public int hashCode() {
                int result = this.expression.hashCode();
                result = result * 31 + this.environment.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EnvironmentCheck)) {
                    return false;
                }
                EnvironmentCheck environmentCheck = (EnvironmentCheck)other;
                if (!Intrinsics.areEqual((Object)this.expression, (Object)environmentCheck.expression)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.environment, (Object)environmentCheck.environment);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            try {
                nArray[AnnotationUsageType.METHOD_CALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.FIELD_REFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.VARIABLE_REFERENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

