/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.resources.ResourceType;
import com.android.utils.PositionXmlParser;
import com.android.utils.XmlUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Deprecated
class ValueResourceParser2 {
    private final File mFile;
    private final String mLibraryName;
    private final ResourceNamespace mNamespace;
    private boolean mTrackSourcePositions = true;
    private boolean mCheckDuplicates = true;

    ValueResourceParser2(File file, ResourceNamespace namespace, String libraryName) {
        this.mFile = file;
        this.mNamespace = namespace;
        this.mLibraryName = libraryName;
    }

    void setTrackSourcePositions(boolean value) {
        this.mTrackSourcePositions = value;
    }

    void setCheckDuplicates(boolean value) {
        this.mCheckDuplicates = value;
    }

    List<ResourceMergerItem> parseFile(DocumentBuilderFactory factory) throws MergingException {
        Document document = ValueResourceParser2.parseDocument(this.mFile, this.mTrackSourcePositions, factory);
        Element rootNode = document.getDocumentElement();
        if (rootNode == null) {
            return Collections.emptyList();
        }
        NodeList nodes = rootNode.getChildNodes();
        int count = nodes.getLength();
        ArrayList<ResourceMergerItem> resources = new ArrayList<ResourceMergerItem>(count);
        EnumMap<ResourceType, Set<String>> map = this.mCheckDuplicates ? new EnumMap<ResourceType, Set<String>>(ResourceType.class) : null;
        int n = nodes.getLength();
        for (int i2 = 0; i2 < n; ++i2) {
            ResourceMergerItem resource;
            Node node = nodes.item(i2);
            if (node.getNodeType() != 1 || (resource = ValueResourceParser2.getResource(node, this.mFile, this.mNamespace, this.mLibraryName)) == null) continue;
            ValueResourceParser2.checkDuplicate(resource, map, this.mFile);
            resources.add(resource);
            if (resource.getType() != ResourceType.STYLEABLE) continue;
            ValueResourceParser2.addStyleableItems(node, resources, map, this.mFile, this.mNamespace, this.mLibraryName);
        }
        return resources;
    }

    static ResourceMergerItem getResource(Node node, File from, ResourceNamespace namespace, String libraryName) throws MergingException {
        ResourceType type = ValueResourceParser2.getType(node, from);
        String name = ValueResourceParser2.getName(node);
        if (name != null) {
            if (type != null) {
                ValueResourceNameValidator.validate(name, type, from);
                return new ResourceMergerItem(name, namespace, type, node, null, libraryName);
            }
        } else if (type == ResourceType.PUBLIC) {
            return new ResourceMergerItem("", namespace, type, node, null, libraryName);
        }
        return null;
    }

    static ResourceType getType(Node node, File from) throws MergingException {
        String nodeName = node.getLocalName();
        if ("eat-comment".equals(nodeName) || "skip".equals(nodeName)) {
            return null;
        }
        ResourceType result2 = ResourceType.fromXmlTag((Node)node);
        if (result2 != null) {
            return result2;
        }
        throw MergingException.withMessage("Can't determine type for tag '%s'", XmlUtils.toXml((Node)node)).withFile(from).build();
    }

    static String getName(Node node) {
        Attr attribute = (Attr)node.getAttributes().getNamedItemNS(null, "name");
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    static Document parseDocument(File file, boolean trackPositions, DocumentBuilderFactory factory) throws MergingException {
        try {
            if (trackPositions) {
                return PositionXmlParser.parse((InputStream)new BufferedInputStream(new FileInputStream(file)), (DocumentBuilderFactory)factory);
            }
            return XmlUtils.parseUtfXmlFile((File)file, (boolean)true);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
    }

    static void addStyleableItems(Node styleableNode, List<ResourceMergerItem> list, Map<ResourceType, Set<String>> map, File from, ResourceNamespace namespace, String libraryName) throws MergingException {
        assert (styleableNode.getNodeName().equals("declare-styleable"));
        NodeList nodes = styleableNode.getChildNodes();
        int n = nodes.getLength();
        for (int i2 = 0; i2 < n; ++i2) {
            ResourceMergerItem resource;
            Node node = nodes.item(i2);
            if (node.getNodeType() != 1 || (resource = ValueResourceParser2.getResource(node, from, namespace, libraryName)) == null) continue;
            assert (resource.getType() == ResourceType.ATTR);
            if (resource.getName().startsWith("android:") || !ValueResourceParser2.hasFormatAttribute(node) && !XmlUtils.hasElementChildren((Node)node)) continue;
            ValueResourceParser2.checkDuplicate(resource, map, from);
            resource.setIgnoredFromDiskMerge(true);
            list.add(resource);
        }
    }

    private static void checkDuplicate(ResourceMergerItem resource, Map<ResourceType, Set<String>> map, File from) throws MergingException {
        String name;
        if (map == null) {
            return;
        }
        Set<String> set = map.get(resource.getType());
        if (set == null) {
            set = new HashSet<String>();
            map.put(resource.getType(), set);
        }
        if (!set.add(name = resource.getName()) && resource.getType() != ResourceType.PUBLIC) {
            String suffix = ValueResourceParser2.hasOutdatedProductAttribute(resource) ? ". Probably you want to define a new flavor for building multiple APKs with different values for the same resource" : "";
            throw MergingException.withMessage("Found item %s/%s more than one time" + suffix, resource.getType().getDisplayName(), name).withFile(from).build();
        }
    }

    private static boolean hasOutdatedProductAttribute(ResourceMergerItem resource) {
        Node node = resource.getValue();
        if (node != null) {
            return node.getAttributes().getNamedItem("product") != null;
        }
        return false;
    }

    private static boolean hasFormatAttribute(Node node) {
        return node.getAttributes().getNamedItemNS(null, "format") != null;
    }
}

