/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontSource;
import com.android.ide.common.fonts.FontType;
import com.android.ide.common.fonts.MutableFontDetail;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u000e\u0010\u001a\u001a\u00020\u001b*\u0004\u0018\u00010\u000bH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d*\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0016\u0010\u001f\u001a\u00020 *\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0007j\b\u0012\u0004\u0012\u00020\u000f`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/android/ide/common/fonts/DirectoryHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "provider", "Lcom/android/ide/common/fonts/FontProvider;", "<init>", "(Lcom/android/ide/common/fonts/FontProvider;)V", "fontDetails", "Ljava/util/ArrayList;", "Lcom/android/ide/common/fonts/MutableFontDetail;", "Lkotlin/collections/ArrayList;", "fontName", "", "fontMenu", "fontMenuName", "fontFamilies", "Lcom/android/ide/common/fonts/FontFamily;", "getFontFamilies", "()Ljava/util/ArrayList;", "startElement", "", "uri", "localName", "name", "attributes", "Lorg/xml/sax/Attributes;", "endElement", "parseType", "Lcom/android/ide/common/fonts/FontType;", "parseIntOrDefault", "", "defaultValue", "parseFloatOrDefault", "", "addProtocol", "url", "sdk-common"})
public final class DirectoryHandler
extends DefaultHandler {
    @NotNull
    private final FontProvider provider;
    @NotNull
    private final ArrayList<MutableFontDetail> fontDetails;
    @NotNull
    private String fontName;
    @NotNull
    private String fontMenu;
    @NotNull
    private String fontMenuName;
    @NotNull
    private final ArrayList<FontFamily> fontFamilies;

    public DirectoryHandler(@NotNull FontProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
        this.fontDetails = new ArrayList();
        this.fontName = "";
        this.fontMenu = "";
        this.fontMenuName = "";
        this.fontFamilies = new ArrayList();
    }

    @NotNull
    public final ArrayList<FontFamily> getFontFamilies() {
        return this.fontFamilies;
    }

    @Override
    public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String name, @NotNull Attributes attributes) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        String string = name;
        if (Intrinsics.areEqual((Object)string, (Object)"family")) {
            String string2 = attributes.getValue("name");
            if (string2 == null) {
                string2 = "";
            }
            this.fontName = string2;
            this.fontMenu = this.addProtocol(attributes.getValue("menu"));
            String string3 = attributes.getValue("menuName");
            if (string3 == null) {
                string3 = "";
            }
            this.fontMenuName = string3;
        } else if (Intrinsics.areEqual((Object)string, (Object)"font")) {
            MutableFontDetail font = new MutableFontDetail();
            font.setType(this.parseType(attributes.getValue("isVf")));
            font.setWeight(this.parseIntOrDefault(attributes.getValue("weight"), 400));
            font.setWidth(this.parseFloatOrDefault(attributes.getValue("width"), 100.0f));
            font.setItalics(this.parseFloatOrDefault(attributes.getValue("italic"), 0.0f));
            font.setFontUrl(this.addProtocol(attributes.getValue("url")));
            String string4 = attributes.getValue("styleName");
            if (string4 == null) {
                string4 = "";
            }
            font.setStyleName(string4);
            if (font.getWeight() > 0 && font.getWidth() > 0.0f && ((CharSequence)font.getFontUrl()).length() > 0) {
                this.fontDetails.add(font);
            }
        }
    }

    @Override
    public void endElement(@NotNull String uri, @NotNull String localName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)name, (Object)"family")) {
            if (((CharSequence)this.fontName).length() > 0 && ((CharSequence)this.fontMenu).length() > 0) {
                this.fontFamilies.add(new FontFamily(this.provider, FontSource.DOWNLOADABLE, this.fontName, this.fontMenu, this.fontMenuName, (List<MutableFontDetail>)this.fontDetails));
            }
            this.fontDetails.clear();
        }
    }

    private final FontType parseType(String $this$parseType) {
        if ($this$parseType == null) {
            return FontType.SINGLE;
        }
        return StringsKt.equals((String)$this$parseType, (String)"true", (boolean)true) ? FontType.VARIABLE : FontType.SINGLE;
    }

    private final int parseIntOrDefault(String $this$parseIntOrDefault, int defaultValue) {
        int n;
        if ($this$parseIntOrDefault == null) {
            return defaultValue;
        }
        try {
            n = Integer.parseInt($this$parseIntOrDefault);
        }
        catch (NumberFormatException numberFormatException) {
            n = defaultValue;
        }
        return n;
    }

    private final float parseFloatOrDefault(String $this$parseFloatOrDefault, float defaultValue) {
        float f;
        if ($this$parseFloatOrDefault == null) {
            return defaultValue;
        }
        try {
            f = Float.parseFloat($this$parseFloatOrDefault);
        }
        catch (NumberFormatException numberFormatException) {
            f = defaultValue;
        }
        return f;
    }

    private final String addProtocol(String url) {
        if (url == null) {
            return "";
        }
        if (StringsKt.startsWith$default((String)url, (String)"//", (boolean)false, (int)2, null)) {
            String string = url.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return "https://" + string;
        }
        return url;
    }
}

