/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.io.CancellableFileIo;
import com.android.utils.Base128InputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u001a\u0010\f\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0011J\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u0002H\u001f\"\u0010\b\u0000\u0010\u001f\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u001f0 H\u0086\b\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0011H\u0017J\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001bJ\b\u0010%\u001a\u00020\u0011H\u0002R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/utils/Base128InputStream;", "Ljava/io/BufferedInputStream;", "stream", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "stringCache", "", "", "setStringCache", "", "readChar", "", "readInt", "", "readLong", "", "readFloat", "", "readFixed32", "readString", "readByte", "", "readBytes", "", "readBoolean", "", "readEnum", "T", "", "()Ljava/lang/Enum;", "read", "validateContents", "expected", "readByteAsInt", "StreamFormatException", "common"})
public final class Base128InputStream
extends BufferedInputStream {
    @Nullable
    private Map<String, String> stringCache;

    public Base128InputStream(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super(stream);
    }

    public Base128InputStream(@NotNull Path file2) throws NoSuchFileException, IOException {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        InputStream inputStream = CancellableFileIo.newInputStream(file2, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        this(inputStream);
    }

    public final void setStringCache(@NotNull Map<String, String> stringCache) {
        Intrinsics.checkNotNullParameter(stringCache, (String)"stringCache");
        this.stringCache = stringCache;
    }

    public final char readChar() throws IOException, StreamFormatException {
        int b = this.readByteAsInt();
        int value = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByteAsInt();
            if (shift == 14 && (b & 0xFC) != 0) {
                throw StreamFormatException.Companion.invalidFormat();
            }
            value |= (b & 0x7F) << shift;
            shift += 7;
        }
        return (char)value;
    }

    public final int readInt() throws IOException {
        int b = this.readByteAsInt();
        int value = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByteAsInt();
            if (shift == 28 && (b & 0xF0) != 0) {
                throw StreamFormatException.Companion.invalidFormat();
            }
            value |= (b & 0x7F) << shift;
            shift += 7;
        }
        return value;
    }

    public final long readLong() throws IOException, StreamFormatException {
        int b = this.readByteAsInt();
        long value = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByteAsInt();
            if (shift == 63 && (b & 0xFE) != 0) {
                throw StreamFormatException.Companion.invalidFormat();
            }
            value |= (long)(b & 0x7F) << shift;
            shift += 7;
        }
        return value;
    }

    public final float readFloat() throws IOException, StreamFormatException {
        return Float.intBitsToFloat(this.readFixed32());
    }

    public final int readFixed32() throws IOException {
        return this.readByteAsInt() | this.readByteAsInt() << 8 | this.readByteAsInt() << 16 | this.readByteAsInt() << 24;
    }

    @Nullable
    public final String readString() throws IOException, StreamFormatException {
        Function1 function1;
        int len = this.readInt();
        if (len < 0) {
            throw StreamFormatException.Companion.invalidFormat();
        }
        if (len == 0) {
            return null;
        }
        if (--len == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(len);
        while (--len >= 0) {
            buf.append(this.readChar());
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String str = string;
        Map<String, String> map = this.stringCache;
        if (map == null || (map = (String)map.computeIfAbsent(str, new Function(function1 = (Function1)readString.1.INSTANCE){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        })) == null) {
            map = str;
        }
        return map;
    }

    public final byte readByte() throws IOException {
        int b = this.readByteAsInt();
        return (byte)b;
    }

    @NotNull
    public final byte[] readBytes() throws IOException, StreamFormatException {
        int len = this.readInt();
        if (len < 0) {
            throw StreamFormatException.Companion.invalidFormat();
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.readByte();
        }
        return bytes;
    }

    public final boolean readBoolean() throws IOException, StreamFormatException {
        int c = this.readInt();
        if ((c & 0xFFFFFFFE) != 0) {
            throw StreamFormatException.Companion.invalidFormat();
        }
        return c != 0;
    }

    public final /* synthetic */ <T extends Enum<T>> T readEnum() throws IOException, StreamFormatException {
        Enum enum_;
        boolean $i$f$readEnum = false;
        int ordinal = this.readInt();
        try {
            Intrinsics.reifiedOperationMarker((int)5, (String)"T");
            enum_ = (Enum)((EnumEntries)null).get(ordinal);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw new StreamFormatException("Invalid ordinal value " + ordinal + " of enum " + Reflection.getOrCreateKotlinClass(Enum.class).getSimpleName());
        }
        return (T)enum_;
    }

    @Override
    @Deprecated(message="Use readByte() or readInt() instead.")
    public int read() {
        throw new UnsupportedOperationException("This method is disabled to prevent unintended accidental use. Please use readByte or readInt instead.");
    }

    public final boolean validateContents(@NotNull byte[] expected) throws IOException {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        boolean result = true;
        for (byte b : expected) {
            if (b == this.readByte()) continue;
            result = false;
        }
        return result;
    }

    private final int readByteAsInt() throws IOException {
        int b = super.read();
        if (b < 0) {
            throw StreamFormatException.Companion.prematureEndOfFile();
        }
        return b;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/android/utils/Base128InputStream$StreamFormatException;", "Ljava/io/IOException;", "message", "", "<init>", "(Ljava/lang/String;)V", "Companion", "common"})
    public static final class StreamFormatException
    extends IOException {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public StreamFormatException(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2);
        }

        @JvmStatic
        @NotNull
        public static final StreamFormatException prematureEndOfFile() {
            return Companion.prematureEndOfFile();
        }

        @JvmStatic
        @NotNull
        public static final StreamFormatException invalidFormat() {
            return Companion.invalidFormat();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/utils/Base128InputStream$StreamFormatException$Companion;", "", "<init>", "()V", "prematureEndOfFile", "Lcom/android/utils/Base128InputStream$StreamFormatException;", "invalidFormat", "common"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final StreamFormatException prematureEndOfFile() {
                return new StreamFormatException("Premature end of file");
            }

            @JvmStatic
            @NotNull
            public final StreamFormatException invalidFormat() {
                return new StreamFormatException("Invalid file format");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

