/*
 * Decompiled with CFR 0.152.
 */
package com.android.testing.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\f\u001a5\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000f\u001a\u001d\u0010\u0010\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0011\u001a\u0016\u0010\u0012\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u001c\u001a\u0015\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u001c\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0010\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"SYSTEM_IMAGE_PREFIX", "", "API_PREFIX", "API_EXTENSION_PREFIX", "PAGE_16K_SOURCE_SUFFIX", "API_OFFSET", "", "VENDOR_OFFSET", "ABI_OFFSET", "computeSystemImageHashFromDsl", "version", "extensionVersion", "imageSource", "pageAlignmentSuffix", "abi", "(ILjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "computeVersionString", "(ILjava/lang/Integer;)Ljava/lang/String;", "computeVendorString", "computeImageSource", "isTvOrAutoSource", "", "is16kPageSource", "vendorString", "isTvOrAutoDevice", "deviceName", "parseApiFromHash", "systemImageHash", "(Ljava/lang/String;)Ljava/lang/Integer;", "parseExtensionFromHash", "parseVendorFromHash", "parseSystemImageSourceFromHash", "parseAbiFromHash", "common"})
public final class SystemImageHashUtilsKt {
    @NotNull
    private static final String SYSTEM_IMAGE_PREFIX = "system-images;";
    @NotNull
    private static final String API_PREFIX = "android-";
    @NotNull
    private static final String API_EXTENSION_PREFIX = "-ext";
    @NotNull
    private static final String PAGE_16K_SOURCE_SUFFIX = "_ps16k";
    private static final int API_OFFSET = 1;
    private static final int VENDOR_OFFSET = 2;
    private static final int ABI_OFFSET = 3;

    @NotNull
    public static final String computeSystemImageHashFromDsl(int version, @Nullable Integer extensionVersion, @NotNull String imageSource, @NotNull String pageAlignmentSuffix, @NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        Intrinsics.checkNotNullParameter((Object)pageAlignmentSuffix, (String)"pageAlignmentSuffix");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        return SYSTEM_IMAGE_PREFIX + SystemImageHashUtilsKt.computeVersionString(version, extensionVersion) + ";" + SystemImageHashUtilsKt.computeVendorString(imageSource, pageAlignmentSuffix) + ";" + abi;
    }

    @NotNull
    public static final String computeVersionString(int version, @Nullable Integer extensionVersion) {
        Object extensionSuffix = extensionVersion != null ? API_EXTENSION_PREFIX + extensionVersion : "";
        return API_PREFIX + version + (String)extensionSuffix;
    }

    @NotNull
    public static final String computeVendorString(@NotNull String imageSource, @NotNull String pageAlignmentSuffix) {
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        Intrinsics.checkNotNullParameter((Object)pageAlignmentSuffix, (String)"pageAlignmentSuffix");
        return SystemImageHashUtilsKt.computeImageSource(imageSource) + pageAlignmentSuffix;
    }

    private static final String computeImageSource(String imageSource) {
        String string;
        switch (imageSource) {
            case "google": {
                string = "google_apis";
                break;
            }
            case "google-atd": {
                string = "google_atd";
                break;
            }
            case "aosp": {
                string = "default";
                break;
            }
            case "aosp-atd": {
                string = "aosp_atd";
                break;
            }
            default: {
                string = imageSource;
            }
        }
        return string;
    }

    public static final boolean isTvOrAutoSource(@NotNull String imageSource) {
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        return StringsKt.contains$default((CharSequence)imageSource, (CharSequence)"-tv", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)imageSource, (CharSequence)"-auto", (boolean)false, (int)2, null);
    }

    public static final boolean is16kPageSource(@NotNull String vendorString) {
        Intrinsics.checkNotNullParameter((Object)vendorString, (String)"vendorString");
        return StringsKt.contains$default((CharSequence)vendorString, (CharSequence)PAGE_16K_SOURCE_SUFFIX, (boolean)false, (int)2, null);
    }

    public static final boolean isTvOrAutoDevice(@NotNull String deviceName) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        return StringsKt.contains$default((CharSequence)deviceName, (CharSequence)"TV", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)deviceName, (CharSequence)"Auto", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final Integer parseApiFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        Object object = new String[]{";"};
        String apiComponent = (String)StringsKt.split$default((CharSequence)systemImageHash, (String[])object, (boolean)false, (int)0, (int)6, null).get(1);
        if (!StringsKt.startsWith$default((String)apiComponent, (String)API_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            object = Integer.parseInt(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)apiComponent, (String)API_PREFIX, null, (int)2, null), (String)API_EXTENSION_PREFIX, null, (int)2, null));
        }
        catch (NumberFormatException e) {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final Integer parseExtensionFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        Object object = new String[]{";"};
        String apiComponent = (String)StringsKt.split$default((CharSequence)systemImageHash, (String[])object, (boolean)false, (int)0, (int)6, null).get(1);
        if (!StringsKt.startsWith$default((String)apiComponent, (String)API_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            String string = StringsKt.substringAfter$default((String)apiComponent, (String)API_EXTENSION_PREFIX, null, (int)2, null);
            object = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        }
        catch (NumberFormatException e) {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final String parseVendorFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String[] stringArray = new String[]{";"};
        return (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)systemImageHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)2);
    }

    @Nullable
    public static final String parseSystemImageSourceFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String string = SystemImageHashUtilsKt.parseVendorFromHash(systemImageHash);
        return string != null ? StringsKt.removeSuffix((String)string, (CharSequence)PAGE_16K_SOURCE_SUFFIX) : null;
    }

    @Nullable
    public static final String parseAbiFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String[] stringArray = new String[]{";"};
        return (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)systemImageHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)3);
    }
}

