/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali.Adaptors.Debug;

import com.android.tools.smali.baksmali.Adaptors.ClassDefinition;
import com.android.tools.smali.baksmali.Adaptors.Debug.DebugMethodItem;
import com.android.tools.smali.baksmali.Adaptors.Debug.LocalFormatter;
import com.android.tools.smali.baksmali.Adaptors.RegisterFormatter;
import com.android.tools.smali.baksmali.formatter.BaksmaliWriter;
import com.android.tools.smali.dexlib2.iface.debug.StartLocal;
import java.io.IOException;
import javax.annotation.Nonnull;

public class StartLocalMethodItem
extends DebugMethodItem {
    @Nonnull
    private final ClassDefinition classDef;
    @Nonnull
    private final StartLocal startLocal;
    @Nonnull
    private final RegisterFormatter registerFormatter;

    public StartLocalMethodItem(@Nonnull ClassDefinition classDef, int codeAddress, int sortOrder, @Nonnull RegisterFormatter registerFormatter, @Nonnull StartLocal startLocal) {
        super(codeAddress, sortOrder);
        this.classDef = classDef;
        this.startLocal = startLocal;
        this.registerFormatter = registerFormatter;
    }

    @Override
    public boolean writeTo(BaksmaliWriter writer) throws IOException {
        writer.write(".local ");
        this.registerFormatter.writeTo(writer, this.startLocal.getRegister());
        String name = this.startLocal.getName();
        String type = this.startLocal.getType();
        String signature = this.startLocal.getSignature();
        if (name != null || type != null || signature != null) {
            writer.write(", ");
            LocalFormatter.writeLocal(writer, name, type, signature);
        }
        return true;
    }
}

