/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.instruction;

import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.instruction.DexBackedInstruction;
import com.android.tools.smali.dexlib2.dexbacked.util.FixedSizeList;
import com.android.tools.smali.dexlib2.iface.instruction.formats.ArrayPayload;
import com.android.tools.smali.util.ExceptionWithContext;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

public class DexBackedArrayPayload
extends DexBackedInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    public final int elementWidth;
    public final int elementCount;
    private static final int ELEMENT_WIDTH_OFFSET = 2;
    private static final int ELEMENT_COUNT_OFFSET = 4;
    private static final int ELEMENTS_OFFSET = 8;

    public DexBackedArrayPayload(@Nonnull DexBackedDexFile dexFile, int instructionStart) {
        super(dexFile, OPCODE, instructionStart);
        int localElementWidth = dexFile.getDataBuffer().readUshort(instructionStart + 2);
        if (localElementWidth == 0) {
            this.elementWidth = 1;
            this.elementCount = 0;
        } else {
            this.elementWidth = localElementWidth;
            this.elementCount = dexFile.getDataBuffer().readSmallUint(instructionStart + 4);
            if ((long)this.elementWidth * (long)this.elementCount > Integer.MAX_VALUE) {
                throw new ExceptionWithContext("Invalid array-payload instruction: element width*count overflows", new Object[0]);
            }
        }
    }

    @Override
    public int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    @Nonnull
    public List<Number> getArrayElements() {
        final int elementsStart = this.instructionStart + 8;
        if (this.elementCount == 0) {
            return ImmutableList.of();
        }
        switch (this.elementWidth) {
            abstract class ReturnedList
            extends FixedSizeList<Number> {
                ReturnedList() {
                }

                @Override
                public int size() {
                    return DexBackedArrayPayload.this.elementCount;
                }
            }
            case 1: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    @Nonnull
                    public Number readItem(int index) {
                        return DexBackedArrayPayload.this.dexFile.getDataBuffer().readByte(elementsStart + index);
                    }
                };
            }
            case 2: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    @Nonnull
                    public Number readItem(int index) {
                        return DexBackedArrayPayload.this.dexFile.getDataBuffer().readShort(elementsStart + index * 2);
                    }
                };
            }
            case 4: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    @Nonnull
                    public Number readItem(int index) {
                        return DexBackedArrayPayload.this.dexFile.getDataBuffer().readInt(elementsStart + index * 4);
                    }
                };
            }
            case 8: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    @Nonnull
                    public Number readItem(int index) {
                        return DexBackedArrayPayload.this.dexFile.getDataBuffer().readLong(elementsStart + index * 8);
                    }
                };
            }
        }
        throw new ExceptionWithContext("Invalid element width: %d", this.elementWidth);
    }

    @Override
    public int getCodeUnits() {
        return 4 + (this.elementWidth * this.elementCount + 1) / 2;
    }
}

